ORCA/M Asm65816 2.1.0

0001 9B37                       TITLE 'Misc Monitor Bank FF Rtnes0'
0002 9B37
0003 9B37              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0004 9B37              ;	by EdAsmCvtIIGS version 1.2d5 on 5/9/91 at 6:11:57 PM
0005 9B37
0006 9B37
0007 9B37              ******************************************************
0008 9B37              *                                                    *
0009 9B37              *        Miscellaneous Monitor Bank FF Routines0     *
0010 9B37              *                                                    *
0011 9B37              *                    by                              *
0012 9B37              *               Fern Bachman     1985-1987           *
0013 9B37              *               Joe Bo           1987-1989           *
0014 9B37              *                                                    *
0015 9B37              *       Copyright Apple Computer, Inc. 1985-1989     *
0016 9B37              *                All Rights Reserved.                *
0017 9B37              *                                                    *
0018 9B37              ******************************************************
0019 9B37
0020 9B37              REGSETFF EQU   *
0021 9B37 20 A2 9B              JSR   REGSETFF1                ;Done this way cause USERSETUP calls it
0022 9B3A 60                    RTS                            ;DO NOT CHANGE THIS!!!!!!!!!!!!!
0023 9B3B
0024 9B3B
0025 9B3B              RESETFF  EQU   *                        ;Part of reset routine
0026 9B3B A9 FF                 LDA   #$FF                     ;Set up checkboard cursor
0027 9B3D 8F 35 01 E1           STA   >CURSOR                  ; for whomever.
0028 9B41 8B                    PHB                            ;Save data bank register
0029 9B42 A9 E1                 LDA   #$E1                     ;Change data bank register
0030 9B44 48                    PHA                            ;
0031 9B45 AB                    PLB                            ;
0032 9B46 A9 40                 LDA   #$40                     ;Set default screen display restore
0033 9B48 8D BB 01              STA   |SCRNSTAT                ; to be textpage1, used in RESUME
0034 9B4B A9 6B                 LDA   #$6B                     ;Set with 'RTL' to tell
0035 9B4D 8D B2 01              STA   |MIDIINPUTPOLL           ; MIDI tool that RESET occurred
0036 9B50 9C 37 01              STZ   |CHGCURFLG               ;Disable change cursor flag
0037 9B53 9C D7 00              STZ   |IRQ_MOUSVBL             ;Reset user gets VBL flag
0038 9B56 9C CB 00              STZ   |IRQ_ACTIVE              ;Reset irq active flag
0039 9B59 9C 01 01              STZ   |SCCSTAT                 ;Reset SCC interrupt byte
0040 9B5C C2 20                 REP   #$20                     ;16 bit stores to follow
0041 9B5E 9C 03 01              STZ   |SCCFLAG2                ;Reset SCCFLAG2/SERFLAG
0042 9B61 9C 43 01              STZ   |C1FLAG                  ;Reset C1FLAG/C2FLAG
0043 9B64 9C C3 00              STZ   |IRQ_INTFLAG             ;Reset INTFLAG/DATAREG
0044 9B67 9C C5 00              STZ   |IRQ_KMSTATUS            ;Reset IRQ_KMSTATUS/IRQ_SECFLAG
0045 9B6A                       LONGA ON
0046 9B6A A9 01 00              LDA   #$0001                   ;Set counter for copy each VBL
0047 9B6D 8D 74 01              STA   |TP2TCNT                 ;Put in task header area
0048 9B70 A9 5A A5              LDA   #$A55A                   ;Signature word
0049 9B73 8D 76 01              STA   |TP2TSIG                 ;Put in task header area
0050 9B76 A9 79 FF              LDA   #>TP2TASK                ;Setup pointer to task to execute
0051 9B79 8D 7A 01              STA   |TP2TJMP+2               ;
0052 9B7C A9 5C 5C              LDA   #TP2TASK*256+$5C         ;Low word of pointer and JMP abslong
0053 9B7F 8D 78 01              STA   |TP2TJMP                 ;
0054 9B82
0055 9B82 A9 79 FF              LDA   #>SETDEFSLT              ;Set pointer to restore default slots assignment
0056 9B85 8D AB 01              STA   |DEFAULTSLT+2            ;
0057 9B88 A9 5C 5B              LDA   #SETDEFSLT*256+$5C       ;Low word of pointer and JMP abslong
0058 9B8B 8D A9 01              STA   |DEFAULTSLT              ;
0059 9B8E A9 79 FF              LDA   #>RSTSYSSLT              ;Set pointer to restore system slots assignment
0060 9B91 8D AF 01              STA   |RESTORSLT+2             ;
0061 9B94 A9 5C 5B              LDA   #RSTSYSSLT*256+$5C       ;Low word of pointer and JMP abslong
0062 9B97 8D AD 01              STA   |RESTORSLT               ;
0063 9B9A                       LONGA OFF
0064 9B9A E2 30                 SEP   #$30                     ;8 bit land now
0065 9B9C 9C 7C 01              STZ   |TP2MODE                 ;0/1 text page 2 copier off/on
0066 9B9F                       LONGA OFF
0067 9B9F E2 30                 SEP   #$30                     ;8 bit land now
0068 9BA1 AB                    PLB                            ;Restore data bank register
0069 9BA2
0070 9BA2              REGSETFF1 EQU   *                       ;Setup regs for MON entry then beep
0071 9BA2 8B                    PHB                            ;Save data bank register
0072 9BA3 8B                    PHB                            ;Save data bank register
0073 9BA4 20 82 F8              JSR   DBTOE1                   ;Switch data bank register
0074 9BA7 AD 68 C0              LDA   |STATEREG                ;Get STATEREG val on entry to bnk FF
0075 9BAA 29 FE                 AND   #$FE                     ;Enable external CXROM
0076 9BAC 8D 2D 01              STA   |MVAL                    ;Save memory state
0077 9BAF A3 0B                 LDA   11,S                     ;Get user CYAREG value
0078 9BB1 29 80                 AND   #$80                     ;Hi bit only important one
0079 9BB3 0D 35 C0              ORA   SHADOW                   ;Or in shadow register
0080 9BB6 8D 2E 01              STA   |QVAL                    ;
0081 9BB9 68                    PLA                            ;Recall data bank register
0082 9BBA 8D 2B 01              STA   |BVAL                    ;Save data bank register
0083 9BBD 8D 2C 01              STA   |KVAL                    ;Prog bnk reg same as data bank reg
0084 9BC0 8D 33 01              STA   |DDVAL                   ;Set disassembly option to zero
0085 9BC3 8D 3E 01              STA   |BANKS                   ;Save also as source bank
0086 9BC6 8D A7 01              STA   |HIGHBANK                ;Save high bank of crossing stuff also
0087 9BC9 C2 30                 REP   #$30                     ;Go to 16 bit land
0088 9BCB 7B                    TDC                            ;Save current direct register value
0089 9BCC 8D 28 01              STA   |DVAL                    ;
0090 9BCF 3B                    TSC                            ;Get stack pointer
0091 9BD0 18                    CLC                            ;Fix for correct value
0092 9BD1                       LONGA ON
0093 9BD1 69 0B 00              ADC   #$000B                   ;Stack pointer is 11 bytes off in here
0094 9BD4 8D 26 01              STA   |SVAL                    ;Save stack pointer
0095 9BD7 A9 01 01              LDA   #$0101                   ;Set 'm'/'x'/'e' values to emulation
0096 9BDA 8D 2F 01              STA   |LVAL                    ;Set language card bank/'m' value to 1
0097 9BDD 8D 31 01              STA   |XPVAL                   ;Set 'x'/'e' values to 1
0098 9BE0                       LONGA OFF
0099 9BE0 E2 30                 SEP   #$30                     ;Back to 8 bit land
0100 9BE2 A0 05                 LDY   #$05                     ;0 out AVAL/XVAL/YVAL
0101 9BE4 A9 00                 LDA   #$00                     ;
0102 9BE6              @1       EQU   *
0103 9BE6 99 20 01              STA   |AVAL,Y                  ;
0104 9BE9 88                    DEY                            ;
0105 9BEA 10 FA                 BPL   @1                       ;Loop til all 0
0106 9BEC 8D 2A 01              STA   |PVAL                    ;'P' value to 0 too
0107 9BEF 8C 34 01              STY   |ASCFILTER               ;ASCII filer mask=$FF as default
0108 9BF2 AB                    PLB                            ;Fix current data bank register
0109 9BF3 60                    RTS                            ;Back to caller
0110 9BF4
0111 9BF4
0112 9BF4              MAKEMXE0 EQU   *                        ;Make 'm'/'x'/'e' native mode internally
0113 9BF4 A9 00                 LDA   #$00                     ;
0114 9BF6 A2 02                 LDX   #$02                     ;Zero out 3 variables
0115 9BF8              @1       EQU   *
0116 9BF8 9F 30 01 E1           STA   >MPVAL,X                 ;Sets internal 'm'/'x'/'e' = native
0117 9BFC CA                    DEX                            ;Next
0118 9BFD 10 F9                 BPL   @1                       ;Loop til done
0119 9BFF 60                    RTS                            ;Back to caller
0120 9C00
0121 9C00
0122 9C00              PREADFF  EQU   *
0123 9C00 AD 36 C0              LDA   CYAREG                   ;Save user speed bit
0124 9C03 48                    PHA                            ;
0125 9C04 29 7F                 AND   #$7F                     ;Switch to slow speed
0126 9C06 08                    PHP                            ;Preserve interrupt status
0127 9C07 78                    SEI                            ;Now disable interrupts
0128 9C08 8D 36 C0              STA   CYAREG                   ;
0129 9C0B AD 70 C0              LDA   PTRIG                    ;Trigger paddles
0130 9C0E A0 00                 LDY   #$00                     ;Init count
0131 9C10 EA                    NOP                            ;Compensate for 1st count
0132 9C11 EA                    NOP                            ;
0133 9C12              @1       EQU   *
0134 9C12 BD 64 C0              LDA   PADDL0,X                 ;Count Y-reg every 12 usec
0135 9C15 10 04                 BPL   @2                       ;+ THEN DONE
0136 9C17 C8                    INY                            ;
0137 9C18 D0 F8                 BNE   @1                       ;Exit at 255 maximum
0138 9C1A 88                    DEY                            ;
0139 9C1B              @2       EQU   *
0140 9C1B 28                    PLP                            ;Restore interrupt mode
0141 9C1C              PREADFFRTS EQU   *
0142 9C1C 68                    PLA                            ;Recall user speed byte
0143 9C1D 8D 36 C0              STA   CYAREG                   ;Restore user speed
0144 9C20 60                    RTS                            ;Exit to caller
0145 9C21
0146 9C21
0147 9C21              FFBANKRTS EQU   *                       ;
0148 9C21 E2 30                 SEP   #$30                     ;Restore monitor mode
0149 9C23 EB                    XBA                            ;Save user's 'A' value
0150 9C24 A9 80                 LDA   #$80                     ;Go fast in here
0151 9C26 0C 36 C0              TSB   CYAREG                   ;
0152 9C29 EB                    XBA                            ;
0153 9C2A 8D 07 C0              STA   SETINTCXROM              ;Restore bank FF operating environment
0154 9C2D 60                    RTS                            ;Back to bank $FF caller
0155 9C2E
0156 9C2E
0157 9C2E                                                      ; SEG $FF
0158 9C2E              RAMVCTRS2 EQU   *                       ;Move interrupt vectors to RAM
0159 9C2E                                                      ; SEG $00
0160 9C2E 8B                    PHB                            ;Save data bank register
0161 9C2F 20 82 F8              JSR   DBTOE1                   ;Change data bank register
0162 9C32
0163 9C32 A2 27                 LDX   #INTVTBLLEN2-1           ;Table length
0164 9C34              @1       EQU   *
0165 9C34 BF 64 7C FF           LDA   >INTVTBL2,X              ;
0166 9C38 9D 80 00              STA   |TOWRITEBR,X             ;
0167 9C3B BF 54 7C FF           LDA   >INTVTBL1,X              ;Set up 4 mgr vctrs + 16 bytes
0168 9C3F 9D 10 00              STA   |INTMGRV,X               ; which are re-set up shortly.
0169 9C42
0170 9C42              * If the new vectors is not of the same length of INTVTBLLEN
0171 9C42              * which is $28, then there are some repetition vectors of INTVTBL2
0172 9C42              * being generated in new vector location which is $e10200.
0173 9C42              * Add in to avoid repetition vectors stuff.
0174 9C42
0175 9C42 E0 20                 CPX   #32                      ;8 new vectors only !!! 
0176 9C44 B0 07                 BCS   @3                       ;BRA if not need to move yet
0177 9C46 BF 34 7C FF           LDA   >INTVTBL0,X              ;New vectors in Gyro
0178 9C4A 9D 00 02              STA   |TOMEMMOVER,X            ;
0179 9C4D              @3       EQU   *
0180 9C4D CA                    DEX                            ;
0181 9C4E 10 E4                 BPL   @1                       ;
0182 9C50
0183 9C50 A2 17                 LDX   #MSGPOINTER-OSVECTORS-1  ;Reset operating system vectors
0184 9C52              @1234    EQU   *
0185 9C52 9E A8 00              STZ   |OSVECTORS,X             ;Reset all operating system values+8 bytes
0186 9C55 CA                    DEX                            ;
0187 9C56 10 FA                 BPL   @1234                    ;Branch til all zeroed out
0188 9C58
0189 9C58 A9 FF                 LDA   #^MSGTBL                 ;Set up MSGPOINTER
0190 9C5A 8D C2 00              STA   |MSGPOINTER+2            ;
0191 9C5D A9 4C                 LDA   #$4C                     ;Put JMP opcode in some vectors
0192 9C5F 8F D0 03 00           STA   >OSWMSTRT                ;In operating system warmstart vector
0193 9C63 8F F5 03 00           STA   >AMPERV                  ;In ampersand vector
0194 9C67 8F F8 03 00           STA   >USRADR                  ;Control-Y vector
0195 9C6B
0196 9C6B                       LONGA ON
0197 9C6B                       LONGI ON
0198 9C6B C2 30                 REP   #$30                     ;Use 16 bit 'm'/'x'
0199 9C6D A9 65 FF              LDA   #MON                     ;Set irq interrupt vector to monitor
0200 9C70 8F FE 03 00           STA   >IRQLOC+0                ;
0201 9C74 8F D1 03 00           STA   >OSWMSTRT+1              ;If no OS on warmstart stay in monitor
0202 9C78 8F F9 03 00           STA   >USRADR+1                ;Control-Y vector
0203 9C7C A9 03 E0              LDA   #$E003                   ;Warm start AppleSoft Basic
0204 9C7F 8F F6 03 00           STA   >AMPERV+1                ;In ampersand vector
0205 9C83 A9 30 84              LDA   #MSGTBL                  ;Move hi and low byte of MSGTBL ptr too
0206 9C86 8D C0 00              STA   |MSGPOINTER              ;
0207 9C89
0208 9C89                       LONGA ON
0209 9C89                       LONGI ON
0210 9C89 A2 5C 00              LDX   #IRQ_LEN-4               ;
0211 9C8C              @2       EQU   *
0212 9C8C A0 BA FF              LDY   #>SECRTL                 ;Bank / hi byte of SECRTL
0213 9C8F A9 5C 18              LDA   #SECRTL*256+$5C          ;JMP abs long / lo byte of SECRTL
0214 9C92 9D 20 00              STA   |IRQ_APTLK,X             ;Put JMP abs long in all vctrs as default
0215 9C95 98                    TYA                            ;Address of SEC/RTL
0216 9C96 9D 22 00              STA   |IRQ_APTLK+2,X           ;Addr of SEC/RTL in all vctrs as default
0217 9C99 CA                    DEX                            ;
0218 9C9A CA                    DEX                            ;
0219 9C9B CA                    DEX                            ;
0220 9C9C CA                    DEX                            ;
0221 9C9D 10 ED                 BPL   @2                       ;Loop til done
0222 9C9F
0223 9C9F A9 C0 BA              LDA   #MICROABORTED            ;Move address of MICROABORTED to IRQ_MICRO
0224 9CA2 8D 51 00              STA   |IRQ_MICRO+1             ;
0225 9CA5 A9 5C F1              LDA   #ROMTOOL*256+$5C         ;Jmp abslong and low byte of ROMTOOL
0226 9CA8 8D 7C 00              STA   |ROMTOOLHOOK+0           ;Save opcode and low byte
0227 9CAB A9 A6 FF              LDA   #>ROMTOOL                ;Bank number and high byte
0228 9CAE 8D 7E 00              STA   |ROMTOOLHOOK+2           ;Finish up operand
0229 9CB1
0230 9CB1                       LONGA OFF
0231 9CB1                       LONGI OFF
0232 9CB1 E2 30                 SEP   #$30                     ;Bank to normal monitor mode
0233 9CB3 A9 FF                 LDA   #^MICROABORTED           ;Move bank of MICROABORTED to IRQ_MICRO
0234 9CB5 8D 53 00              STA   |IRQ_MICRO+3             ;
0235 9CB8
0236 9CB8              * Test for Ensoniq chip here and set ENSONIQFLG appropriately.
0237 9CB8              * It's always here so force status
0238 9CB8              *
0239 9CB8              * ENSONIQFLG = 0 if sound chip is installed
0240 9CB8              *            = <>0 if no sound chip is installed
0241 9CB8
0242 9CB8 9C D6 00              STZ   |ENSONIQFLG              ;Indicate always present
0243 9CBB AB                    PLB                            ;Restore entry data bank
0244 9CBC 4C 9B BB              JMP   SETUPSLOTS               ;Set up internal versus external slots
0245 9CBF
0246 9CBF
0247 9CBF              RAMVCTRS EQU   *                        ;Move interrupt vectors to RAM
0248 9CBF
0249 9CBF
0250 9CBF              * '2' out text page 2.
0251 9CBF
0252 9CBF C2 10                 REP   #$10                     ;16 bit index needed
0253 9CC1                       LONGI ON
0254 9CC1 A2 FF 07              LDX   #$07FF                   ;Space out text page 2
0255 9CC4                       LONGI OFF
0256 9CC4 A9 B2                 LDA   #'2'                     ;'2'
0257 9CC6              @1       EQU   *
0258 9CC6 9F 00 08 E0           STA   >$E00800,X               ;
0259 9CCA CA                    DEX                            ;
0260 9CCB 10 F9                 BPL   @1                       ;
0261 9CCD
0262 9CCD E2 30                 SEP   #$30                     ;Back to normal monitor mode
0263 9CCF
0264 9CCF
0265 9CCF              * The monitor MUST zero out the mouse mode screen hole
0266 9CCF              * so that the desk accessory manager can tell if the
0267 9CCF              * mouse has ever been turned on or not.
0268 9CCF
0269 9CCF AD 68 C0              LDA   STATEREG                 ;Save state
0270 9CD2 48                    PHA                            ;
0271 9CD3 8D 06 C0              STA   SETSLOTCXROM             ;Always look at what's there
0272 9CD6
0273 9CD6 A9 C1                 LDA   #$C1                     ;Starting slot is 1
0274 9CD8 85 01                 STA   LOC1                     ;
0275 9CDA 64 00                 STZ   LOC0                     ;
0276 9CDC              @11      EQU   *
0277 9CDC A2 03                 LDX   #$03                     ;Test 4 bytes for mouse card
0278 9CDE              @22      EQU   *
0279 9CDE BF 67 FB FF           LDA   >MCOFFSET,X              ;Get byte to test offset from table
0280 9CE2 A8                    TAY                            ;Move for proper indexing
0281 9CE3 BF 6B FB FF           LDA   >MIDVALUE,X              ;What's correct byte for here??
0282 9CE7 D1 00                 CMP   (LOC0),Y                 ;Test against card value
0283 9CE9 D0 0B                 BNE   @33                      ;Not = then try next card
0284 9CEB CA                    DEX                            ;= then test next byte on same card
0285 9CEC 10 F0                 BPL   @22                      ;Loop
0286 9CEE
0287 9CEE              * If here then zero out mouse control byte for this slot.
0288 9CEE
0289 9CEE A5 01                 LDA   LOC1                     ;What slot we looking at?
0290 9CF0 29 07                 AND   #$07                     ;Make $Cn into $0n for indexing
0291 9CF2 AA                    TAX                            ;
0292 9CF3 9E F8 07              STZ   MOUSMODE-4,X             ;Make DA manager think mouse is off
0293 9CF6
0294 9CF6              @33      EQU   *
0295 9CF6 E6 01                 INC   LOC1                     ;Next slot please
0296 9CF8 A5 01                 LDA   LOC1                     ;Done yet?
0297 9CFA C9 C8                 CMP   #$C8                     ;Yes if $C8
0298 9CFC 90 DE                 BCC   @11                      ;Test new card
0299 9CFE
0300 9CFE 68                    PLA                            ;Restore monitor state
0301 9CFF 8D 68 C0              STA   STATEREG                 ;
0302 9D02
0303 9D02              @3       EQU   *                        ;Restart here if error
0304 9D02 22 00 00 FE           JSL   >INITDISMGR              ;Init Tool Locator dispatch manager
0305 9D06 90 08                 BCC   @4                       ;'c'=0 then all's OK
0306 9D08 A9 00                 LDA   #$00                     ;Bad then zero out memory manager pwr byte
0307 9D0A 8F FF 15 E1           STA   >RAMDSKPWRUP             ;
0308 9D0E 80 F2                 BRA   @3                       ;Loop til all's OK
0309 9D10
0310 9D10              @4       EQU   *
0311 9D10
0312 9D10 AF F8 02 E1           LDA   >USERRSTRAM              ;Get the reset ramdisk bram byte
0313 9D14 F0 0A                 BEQ   @5                       ;If no reset ramdisk selected, do nothing
0314 9D16 A9 00                 LDA   #$00                     ;Else set no for next round
0315 9D18 8F F8 02 E1           STA   >USERRSTRAM              ;
0316 9D1C 22 4E B9 FF           JSL   >WRITEBR                 ;Need to write to batteryram
0317 9D20
0318 9D20              @5       EQU   *
0319 9D20 A9 00                 LDA   #$00                     ;Zero out serial prt powerup bytes if here
0320 9D22 8F FE 0F E1           STA   >SERPWRUP                ;
0321 9D26 8F FF 0F E1           STA   >SERPWRUP+1              ;
0322 9D2A
0323 9D2A 22 16 B9 FF           JSL   >INITCLOCK               ;Don't let the clock in test mode
0324 9D2E 20 00 56              JSR   |PROCONINIT              ;Init protocol converter
0325 9D31 22 0C 00 FE           JSL   >APTALKINIT              ;Init AppleTalk (Coldstart)
0326 9D35 60                    RTS   
0327 9D36
0328 9D36
0329 9D36              TSTMONDSKACC EQU   *
0330 9D36 08                    PHP                            ;Save 'm'/'x' status
0331 9D37 E2 30                 SEP   #$30                     ;Do tests in 8 bit mode
0332 9D39 AF 7D 01 E1           LDA   >ROMDAACT                ;
0333 9D3D AA                    TAX   
0334 9D3E AF 19 03 E1           LDA   >BRAMDAACT               ;Test if any application set to activate ROMDA
0335 9D42 F0 0C                 BEQ   @1                       ;BRA if NO 
0336 9D44 8A                    TXA                            ;Test if we should reactivate ROM dsk accs
0337 9D45              *                              ;Bit7=1=install it--bit6=1=is installed
0338 9D45              @2       EQU   *
0339 9D45 29 BF                 AND   #$BF                     ;Reset bit 6
0340 9D47 8F 7D 01 E1           STA   >ROMDAACT                ; so the ROM dsk accs will be installed.
0341 9D4B 20 79 79              JSR   ENMONDSKACC1             ;Reenable monitor/memory peeker dsk acc
0342 9D4E              @5       EQU   *
0343 9D4E 28                    PLP                            ;Recall 'm'/'x' status
0344 9D4F 6B                    RTL                            ;Back to caller
0345 9D50
0346 9D50              @1       EQU   *
0347 9D50 8A                    TXA   
0348 9D51 30 F2                 BMI   @2
0349 9D53 28                    PLP   
0350 9D54 6B                    RTL   
0351 9D55
0352 9D55
0353 9D55              CONV2ASC EQU   *
0354 9D55 29 0F                 AND   #$0F                     ;Do low nybble only
0355 9D57 09 B0                 ORA   #$B0                     ;
0356 9D59 C9 BA                 CMP   #$BA                     ;Test for number of letter
0357 9D5B 90 02                 BCC   @1                       ;<$BA then it's a number
0358 9D5D 69 06                 ADC   #$06                     ;If here it's a letter
0359 9D5F              @1       EQU   *
0360 9D5F 60                    RTS                            ;Back to caller
0361 9D60
0362 9D60
0363 9D60
0364 9D60
0365 9D60                       TITLE 'Misc Monitor Bank FF Rtnes0'
0366 9D60
0367 9D60              ******************************************************
0368 9D60              *                                                    *
0369 9D60              *        Miscellaneous Monitor Bank FF Routines00    *
0370 9D60              *                                                    *
0371 9D60              *                    by                              *
0372 9D60              *               Joe Bo           1987-1989           *
0373 9D60              *                                                    *
0374 9D60              *       Copyright Apple Computer, Inc. 1987-1987     *
0375 9D60              *                All Rights Reserved.                *
0376 9D60              *                                                    *
0377 9D60              ******************************************************
0378 9D60
0379 9D60              *
0380 9D60              * STEP/TRACE stack structure
0381 9D60              *
0382 9D60              *    ------------
0383 9D60              *    |  <GOS    | <-- For returning back to monitor      
0384 9D60              *    |  >GOS    |     when 'esc' key is hit
0385 9D60              *    | TraceRate| <-- Trace rate value
0386 9D60              *    |  'P'     | <-- Store 'c'/'v'              
0387 9D60              *    |Monitor Bk| <-- For returning back to step/tace
0388 9D60              *    | <STEPSP  |     after finishing each user instruction
0389 9D60              *    | >STEPSP  |
0390 9D60              *    |          |
0391 9D60              *    |    |     | <-- Reserved for monitor step/trace   
0392 9D60              *    |    |     |     to be used when they are activated
0393 9D60              *    |    |     |     from $01bf-$01ff
0394 9D60              *    |          |
0395 9D60              *    |   SVAL   | <-- User stack space starts from here
0396 9D60              *    |    |     | <-- If specified >=$0180 then force to $017F
0397 9D60              *    |    |     |     if < $110 then error and back to
0398 9D60              *    |    |     |     monitor
0399 9D60              *    |          | <-- low end for user sp $110 !!
0400 9D60              *    |    |     | <-- Too low if below here to $100 
0401 9D60              *    |    |     |
0402 9D60              *    |          |
0403 9D60              *    ------------
0404 9D60              *
0405 9D60              TRACEFF  EQU   *
0406 9D60 22 74 00 E1           JSL   >TRACEVECTOR             ;See if anything out there
0407 9D64 A9 06                 LDA   #TRACEMSG                ;Display 'Trace' message
0408 9D66              TRACEFF2 EQU   *
0409 9D66 B0 01                 BCS   TRACE1                   ;'c'=1, trace not done yet !
0410 9D68 60                    RTS                            ;Back to caller
0411 9D69              TRACE1   EQU   *
0412 9D69 20 80 C0              JSR   PRINTMSG
0413 9D6C 38                    SEC                            ;'c' = 1, trace
0414 9D6D 80 0D                 BRA   STEP1
0415 9D6F
0416 9D6F
0417 9D6F              STEPFF   EQU   *
0418 9D6F 22 78 00 E1           JSL   >STEPVECTOR              ;See if anything out there
0419 9D73 A9 05                 LDA   #STEPMSG                 ;Display 'Step' message
0420 9D75 B0 01                 BCS   STEP0                    ;'c'=1 then step not done yet !
0421 9D77 60                    RTS                            ;Else return back to monitor
0422 9D78              STEP0    EQU   *
0423 9D78 20 80 C0              JSR   PRINTMSG                 ;Display it
0424 9D7B 18                    CLC                            ;'c'=0, step
0425 9D7C
0426 9D7C              STEP1    EQU   *
0427 9D7C 8B                    PHB                            ;Save original data bank on stack
0428 9D7D AD 68 C0              LDA   STATEREG                 ;Save state register 
0429 9D80 48                    PHA   
0430 9D81 20 DA A7              JSR   FIXE1PCLH                ;Move PCL/PCH to bank E1 in case alt zp
0431 9D84
0432 9D84                       LONGA ON                       	; Interrupt was disable from 'FIXE1PCLH'
0433 9D84                       LONGI ON                       	;From 'FIXE1PCLH', also data bank = $e1
0434 9D84 AE 35 C0              LDX   SHADOW                   ;Save SHADOW/CYAREG registers
0435 9D87 DA                    PHX   
0436 9D88 3B                    TSC                            ;Save stk reg, for return back to monitor
0437 9D89 8D 3C 01              STA   |GOS                     ;Save for later restoring
0438 9D8C 08                    PHP                            ;Temporary save step/trace 'c'
0439 9D8D AD 26 01              LDA   |SVAL                    ;Get usr's stack pointer
0440 9D90 C9 00 02              CMP   #$0200                   ;Is it same as monitor stack space
0441 9D93 B0 16                 BCS   @1                       ;If not, leave it alone
0442 9D95 C9 80 01              CMP   #$0180                   ;Is it within my monitor ranges
0443 9D98 90 08                 BCC   @0                       ;BRA if not        
0444 9D9A A9 7F 01              LDA   #$017F                   ;Else force to this value
0445 9D9D 8D 26 01              STA   |SVAL                    ;Set to new value
0446 9DA0 80 09                 BRA   @1                       ;Continue on
0447 9DA2
0448 9DA2              @0       EQU   *
0449 9DA2 C9 10 01              CMP   #$0110                   ;Is it too low ?
0450 9DA5 B0 04                 BCS   @1                       ;BRA if ok, $0110-$01a0 safe area
0451 9DA7 DA                    PHX                            ;Dummy push for exit
0452 9DA8 4C 2C A2              JMP   TOMON1                   ;Exit to monitor
0453 9DAB
0454 9DAB              @1       EQU   *
0455 9DAB 28                    PLP                            ;Restore step/trace 'c'
0456 9DAC              *
0457 9DAC              * The step/trace code sets emulation mode while running
0458 9DAC              *  in bank $FF!  If an interrupt comes under these circumstances
0459 9DAC              *  the machine crashes.  To remedy this problem, interrupts are
0460 9DAC              *  disabled during step and trace operation.  An interrupt window is
0461 9DAC              *  opened right around the call to get keys (in case the event mgr
0462 9DAC              *  is active ... it relies on interrupts to get keystrokes).
0463 9DAC              *  Interrupts are reenabled upon return to monitor mode.
0464 9DAC              *
0465 9DAC 58                    CLI                            ;Enable interrupt
0466 9DAD
0467 9DAD                       LONGA OFF                      	;Off to 8 bit land
0468 9DAD                       LONGI OFF
0469 9DAD E2 30                 SEP   #$30
0470 9DAF 9C BA 01              STZ   |JSX                     ;Set no real time jsx and w/regs display
0471 9DB2 A9 7F                 LDA   #$7F                     ;Default trace rate
0472 9DB4 48                    PHA                            ;Store on stack
0473 9DB5 B8                    CLV                            ;'c'=1, 'v'=0, normal trace mode
0474 9DB6 08                    PHP                            ;Save on stack
0475 9DB7 F4 00 00              PEA   $0000                    ;Set back monitor data bank $00
0476 9DBA AB                    PLB   
0477 9DBB AB                    PLB   
0478 9DBC              STEPMORE EQU   *
0479 9DBC 20 2C AD              JSR   DISASEM                  ;Display user instruction at its pc
0480 9DBF              *
0481 9DBF              * The code above this point has trashed the A1L value so that it
0482 9DBF              *  no longer contains the user's bank.  Restore it here so that the
0483 9DBF              *  'X' command can work on the first instruction in the step. {MSA 4/13/89}
0484 9DBF              *
0485 9DBF AF 3E 01 E1           LDA   >BANKS
0486 9DC3 85 3C                 STA   A1L                      ;Should be zero page!
0487 9DC5              *
0488 9DC5
0489 9DC5
0490 9DC5              LOOPKBD  EQU   *
0491 9DC5 20 6B CF              JSR   XRKBD1                   ;Read keyboard input
0492 9DC8 10 03                 BPL   @1                       ;BRA if no key hit
0493 9DCA 4C 95 9E              JMP   FUNCTION                 ;Key hit, what functions ?
0494 9DCD              @1       EQU   *
0495 9DCD 28                    PLP                            ;Get the previous mode: step or trace ?
0496 9DCE 08                    PHP                            ;Store back for later use
0497 9DCF 90 1D                 BCC   JUSTTRACE                ;Bra if in step mode
0498 9DD1 50 1B                 BVC   JUSTTRACE                ;Bra for normal trace mode
0499 9DD3 A0 00                 LDY   #$0                      ;Set y=0 for reading an opcode
0500 9DD5 20 8B B4              JSR   READPCY                  ;Read it and return in 'A'
0501 9DD8 C9 60                 CMP   #$60                     ;RTS ?
0502 9DDA F0 08                 BEQ   EXITRTX
0503 9DDC C9 40                 CMP   #$40                     ;RTI ?
0504 9DDE F0 04                 BEQ   EXITRTX
0505 9DE0 C9 6B                 CMP   #$6B                     ;RTL ?
0506 9DE2 D0 0A                 BNE   JUSTTRACE                ;Bra if not RTL 
0507 9DE4              EXITRTX  EQU   *
0508 9DE4 28                    PLP                            ;Get rid of previous c/v
0509 9DE5 68                    PLA                            ;Get rid of trace rate count
0510 9DE6 A9 7F                 LDA   #$7F                     ;Set to normal trace rate
0511 9DE8 48                    PHA                            ;Save back to stack
0512 9DE9 B8                    CLV                            ;Clean off flag to stop at rtx
0513 9DEA 18                    CLC                            ;When exit from 'RTx', set to step mode
0514 9DEB 08                    PHP                            ;Store back to stack
0515 9DEC 80 D7                 BRA   LOOPKBD                  ;Loop for key hit
0516 9DEE
0517 9DEE              JUSTTRACE EQU   *
0518 9DEE AF BA 01 E1           LDA   >JSX                     ;Is real time execution of JSX active ?
0519 9DF2 10 10                 BPL   JUSTTRACE1               ;Bra if not activated, BIT7
0520 9DF4 A0 00                 LDY   #$0                      ;Else check for JSx opcode
0521 9DF6 20 8B B4              JSR   READPCY                  ;Read opcode at current PCK/PCH/PCL
0522 9DF9 C9 20                 CMP   #$20                     ;Is it 'JSR'
0523 9DFB F0 04                 BEQ   @1                       ;Bra for doing real time JSR
0524 9DFD C9 22                 CMP   #$22                     ;Is it 'JSL'
0525 9DFF D0 03                 BNE   JUSTTRACE1               ;Bra if not
0526 9E01              @1       EQU   *
0527 9E01 4C E7 9E              JMP   REALJSX                  ;Go do JSR OR JSL routine in real
0528 9E04
0529 9E04              JUSTTRACE1 EQU   *
0530 9E04 28                    PLP                            ;Get 'c'
0531 9E05 08                    PHP                            ;Save back
0532 9E06 90 BD                 BCC   LOOPKBD                  ;Bra if in step and not real time JSx
0533 9E08 A3 02                 LDA   2,S                      ;Get trace rate
0534 9E0A 20 A8 FC              JSR   WAIT                     ;Make a delay between each trace
0535 9E0D 4C 25 A0              JMP   STEPTR                   ;Jump to execute user's instruction
0536 9E10
0537 9E10              ONOFFREGS EQU   *
0538 9E10 AF BA 01 E1           LDA   >JSX
0539 9E14 49 40                 EOR   #$40                     ;Bit 6
0540 9E16 8F BA 01 E1           STA   >JSX                     ;
0541 9E1A 80 A9                 BRA   LOOPKBD                  ;
0542 9E1C
0543 9E1C              GOKEY    EQU   *
0544 9E1C 28                    PLP                            ;Clean stack
0545 9E1D 68                    PLA                            ;
0546 9E1E A2 00                 LDX   #$00                     ;For A1PC routine call in RESUME
0547 9E20 4C 15 A7              JMP   RESUMEFF                 ;Continue on with resume routine
0548 9E23
0549 9E23              WAITRTX  EQU   *
0550 9E23 28                    PLP                            ;Clean out the stack
0551 9E24 E2 40                 SEP   #$40                     ;Set v=1 as indicator for waiting rtx
0552 9E26 08                    PHP   
0553 9E27 80 69                 BRA   LOOPKBD5                 ;Save c/v and go back
0554 9E29
0555 9E29              CHKJSX   EQU   *
0556 9E29 AF BA 01 E1           LDA   >JSX                     ;Prepare to set bit7
0557 9E2D 09 80                 ORA   #$80                     ;
0558 9E2F 8F BA 01 E1           STA   >JSX                     ;
0559 9E33 80 5D                 BRA   LOOPKBD5                 ;Go back
0560 9E35
0561 9E35              MYTEXT   EQU   *
0562 9E35 A9 40                 LDA   #$40                     ;Set bit6 to turn on text
0563 9E37 80 1B                 BRA   SETSCRN                  ;Do it and exit
0564 9E39              DOUBLE   EQU   *
0565 9E39 A9 80                 LDA   #$80                     ;Prepare to turn off super hi
0566 9E3B 1C 29 C0              TRB   NEWVIDEO                 ;Do it
0567 9E3E AD 50 C0              LDA   TXTCLR                   ;Turn on graphic
0568 9E41 AD 5F C0              LDA   CLRAN3                   ;Turn on double res
0569 9E44 80 4C                 BRA   LOOPKBD5                 ;Exit
0570 9E46              MYMIXED  EQU   *
0571 9E46 A9 20                 LDA   #$20                     ;Set bit for mixed mode
0572 9E48 80 0A                 BRA   SETSCRN                  ;Do it and exit
0573 9E4A              MYHIRES  EQU   *
0574 9E4A A9 10                 LDA   #$10                     ;Set bit4 for hi-res
0575 9E4C 80 06                 BRA   SETSCRN                  ;Do it and exit
0576 9E4E              MYLORES  EQU   *
0577 9E4E A9 00                 LDA   #$00                     ;Set for low-res
0578 9E50 80 02                 BRA   SETSCRN                  ;Do it and exit
0579 9E52              MYSUPER  EQU   *
0580 9E52 A9 80                 LDA   #$80                     ;Set bit7 for super hi-res
0581 9E54              SETSCRN  EQU   *
0582 9E54 8F BB 01 E1           STA   >SCRNSTAT                ;Store here as new value
0583 9E58 A9 80                 LDA   #$80                     ;Any way turn off super hi-res first
0584 9E5A 1C 29 C0              TRB   NEWVIDEO                 ;
0585 9E5D 8D 5E C0              STA   SETAN3                   ;Double off
0586 9E60 20 11 A8              JSR   BRKSCRN                  ;Set to new screen mode
0587 9E63 80 2D                 BRA   LOOPKBD5                 ;Go back and continue in my world !
0588 9E65
0589 9E65              CHARKEYS EQU   *
0590 9E65 29 DF                 AND   #$DF                     ;Mask off lower case 
0591 9E67 C9 CF                 CMP   #'O'                     ;ON/OFF registers display
0592 9E69 F0 A5                 BEQ   ONOFFREGS                ;
0593 9E6B C9 CA                 CMP   #'J'                     ;CHK for 'J'
0594 9E6D F0 AD                 BEQ   GOKEY                    ;
0595 9E6F C9 D2                 CMP   #'R'                     ;Command to stop at rtx
0596 9E71 F0 B0                 BEQ   WAITRTX                  ;
0597 9E73 C9 D8                 CMP   #'X'                     ;Command to execute JSx subroutine in real
0598 9E75 F0 B2                 BEQ   CHKJSX                   ;
0599 9E77 C9 D4                 CMP   #'T'                     ;Change the display to text mode
0600 9E79 F0 BA                 BEQ   MYTEXT                   ;
0601 9E7B C9 C4                 CMP   #'D'                     ;Change the display to graphic mode
0602 9E7D F0 BA                 BEQ   DOUBLE                   ;
0603 9E7F C9 CD                 CMP   #'M'                     ;To mixed mode
0604 9E81 F0 C3                 BEQ   MYMIXED                  ;
0605 9E83 C9 C8                 CMP   #'H'                     ;To hi-res     
0606 9E85 F0 C3                 BEQ   MYHIRES                  ;
0607 9E87 C9 CC                 CMP   #'L'                     ;To low res
0608 9E89 F0 C3                 BEQ   MYLORES                  ;
0609 9E8B C9 D3                 CMP   #'S'                     ;To super hi res
0610 9E8D F0 C3                 BEQ   MYSUPER                  ;
0611 9E8F              NOTCLAIM EQU   *
0612 9E8F 20 51 9A              JSR   NEWBELL1                 ;Unrecognized keys, Beep
0613 9E92              LOOPKBD5 EQU   *
0614 9E92 4C C5 9D              JMP   LOOPKBD                  ;Go back for more commands
0615 9E95
0616 9E95
0617 9E95              FUNCTION EQU   *
0618 9E95 C9 C1                 CMP   #'A'                     ;Split off from here
0619 9E97 B0 CC                 BCS   CHARKEYS                 ;BRA if within char keys range
0620 9E99 C9 9B                 CMP   #$9B                     ;Check for 'esc'
0621 9E9B F0 17                 BEQ   TOMON                    ;Back to monitor
0622 9E9D C9 A0                 CMP   #$A0                     ;Check for 'space bar'
0623 9E9F F0 17                 BEQ   SPACEKEY
0624 9EA1 C9 8D                 CMP   #$8D                     ;Check for 'CR'
0625 9EA3 F0 19                 BEQ   CRKEY
0626 9EA5 C9 88                 CMP   #$88                     ;'<--', Slow trace rate
0627 9EA7 F0 21                 BEQ   SLOWRATE
0628 9EA9 C9 95                 CMP   #$95                     ;'-->', Fast trace rate
0629 9EAB F0 23                 BEQ   FASTRATE                 ;
0630 9EAD C9 8A                 CMP   #$8A                     ;Down arrow key?
0631 9EAF F0 28                 BEQ   SKIPONE                  ;Skip current instruction
0632 9EB1 4C 8F 9E              JMP   NOTCLAIM                 ;Not defined keys
0633 9EB4
0634 9EB4              TOMON    EQU   *                        ;'ESC' command
0635 9EB4 58                    CLI                            ;Make sure interrupt is on when exit
0636 9EB5 4C B6 A7              JMP   GO816_EXT                ;Exit step/trace and back to monitor
0637 9EB8
0638 9EB8              SPACEKEY EQU   *                        ;'Space' command
0639 9EB8 28                    PLP                            ;Get previous 'c', 1 = trace ; 0 = step
0640 9EB9 90 0B                 BCC   SWITCH                   ;If in step mode, stay it
0641 9EBB 18                    CLC                            ;Else switch from trace to step mode
0642 9EBC 80 08                 BRA   SWITCH                   ;Prepare to execute user instruction
0643 9EBE
0644 9EBE              CRKEY    EQU   *                        ;'CR' command
0645 9EBE 28                    PLP                            ;Get back previous 'c'
0646 9EBF B0 05                 BCS   SWITCH                   ;If in trace mode, stay it
0647 9EC1 38                    SEC                            ;Else switch from step to trace mode
0648 9EC2 68                    PLA                            ;Get rid of previous trace rate
0649 9EC3 A9 7F                 LDA   #$7F                     ;Set to default trace rate
0650 9EC5 48                    PHA                            ;Save back
0651 9EC6              SWITCH   EQU   *
0652 9EC6 08                    PHP                            ;Save back 'c'/'v'
0653 9EC7 4C 25 A0              JMP   STEPTR                   ;Jmp to execute user's instruction
0654 9ECA
0655 9ECA              SLOWRATE EQU   *
0656 9ECA 28                    PLP                            ;Temp pull back
0657 9ECB 68                    PLA                            ;Get rid of previous trace rate
0658 9ECC A9 FF                 LDA   #$FF                     ;Set with low rate
0659 9ECE 80 04                 BRA   LOOPKBD4
0660 9ED0              FASTRATE EQU   *
0661 9ED0 28                    PLP                            ;Temp pull back
0662 9ED1 68                    PLA                            ;Get rid of previous trace rate
0663 9ED2 A9 3F                 LDA   #$3F                     ;Set with fast rate
0664 9ED4              LOOPKBD4 EQU   *
0665 9ED4 48                    PHA                            ;Save back
0666 9ED5 08                    PHP                            ;Save c/v
0667 9ED6 4C C5 9D              JMP   LOOPKBD                  ;Go back
0668 9ED9
0669 9ED9              SKIPONE  EQU   *
0670 9ED9                       LONGA ON
0671 9ED9 C2 20                 REP   #$20                     ;
0672 9EDB 4B                    PHK                            ;Set up return address
0673 9EDC F4 BB 9D              PEA   STEPMORE-1               ;
0674 9EDF 3B                    TSC                            ;
0675 9EE0 8F 8C 01 E1           STA   >STEPSP                  ;
0676 9EE4 4C 0A A2              JMP   XEND1                    ;Exit in common routine
0677 9EE7
0678 9EE7              REALJSX  EQU   *
0679 9EE7                       LONGA OFF
0680 9EE7 AF BA 01 E1           LDA   >JSX
0681 9EEB 29 7F                 AND   #$7F                     ;
0682 9EED 8F BA 01 E1           STA   >JSX                     ;
0683 9EF1
0684 9EF1                       LONGA ON
0685 9EF1                       LONGI ON
0686 9EF1 C2 30                 REP   #$30                     ;Off to 16 bit land
0687 9EF3 4B                    PHK                            ;Save monitor bank
0688 9EF4 F4 BB 9D              PEA   STEPMORE-1               ;Save step/trace return address
0689 9EF7 3B                    TSC                            ;Save monitor stack pointer
0690 9EF8 8F 8C 01 E1           STA   >STEPSP                  ;Save it
0691 9EFC 18                    CLC                            ;'c'=0, as indicator for calling from real time JSx
0692 9EFD                       LONGA OFF
0693 9EFD                       LONGI OFF
0694 9EFD E2 30                 SEP   #$30                     ;Back to 8 bit land
0695 9EFF 08                    PHP                            ;Save 'c' and m/x
0696 9F00
0697 9F00              *
0698 9F00              * If the JSx routine is a Prodos8/Prodos16 MLI call,
0699 9F00              * then special adjustment for user PCH/PCL is needed
0700 9F00              * so that it would continue in my step/trace world.
0701 9F00              * For JSR, new PC = current PC + 3 (bank $00 only),
0702 9F00              * For JSL, new PC = current PC + 6 (any bank).                      
0703 9F00              *
0704 9F00              * For JSR call, it starts execution at the current JSR location,
0705 9F00              * pre-compute and modified the user next opcode (after JSR) with
0706 9F00              * RTL, $6B is required. Doing this, when hit user RTS, it gets to
0707 9F00              * the modified RTL and helping to branch back to the monitor step
0708 9F00              * trace world.
0709 9F00              * For JSL call, it never execute the JSL itself and therefore the
0710 9F00              * user RTL is easily dispatched by the monitor step/trace  
0711 9F00              *
0712 9F00              NOTREAL  EQU   *                        ;Entry point for normal JSx call
0713 9F00 A4 2F                 LDY   LENGTH                   ;2=JSR, 3=JSL
0714 9F02 C0 03                 CPY   #$3                      ;JSR or JSL ?
0715 9F04 D0 03                 BNE   JSRSTUFF                 ;Bra for JSR
0716 9F06 4C B2 9F              JMP   JSLSTUFF
0717 9F09
0718 9F09              JSRSTUFF EQU   *
0719 9F09 20 8B B4              JSR   READPCY                  ;Tst for PRODOS8 MLIcall,$BF00;tst for $BF
0720 9F0C C9 BF                 CMP   #>PRO8MLI                ;Hi byte of MLI call address
0721 9F0E D0 11                 BNE   NOTMLI8                  ;Bra if high byte not equal $BF
0722 9F10 88                    DEY                            ;Index to read low byte
0723 9F11 20 8B B4              JSR   READPCY                  ;Get low byte, test for $00
0724 9F14 0F 3E 01 E1           ORA   >BANKS                   ;Src bank and low byte both 0 if MLI call
0725 9F18 D0 07                 BNE   NOTMLI8                  ;Bra if not PRODOS8 MLI call
0726 9F1A A9 05                 LDA   #$05
0727 9F1C 85 2F                 STA   LENGTH                   ;Store back, good for 'FIXPC'
0728 9F1E 68                    PLA                            ;Clean stack
0729 9F1F 80 03                 BRA   MLICALL                  ;Bra for real time PRODOS8 MLI call
0730 9F21
0731 9F21              NOTMLI8  EQU   *
0732 9F21 28                    PLP                            ;Get back 'c'
0733 9F22 B0 36                 BCS   JSRNOTRL                 ;Bra if NOT doing real time of any JSR
0734 9F24              MLICALL  EQU   *
0735 9F24              JSRREAL  EQU   *
0736 9F24 A5 3A                 LDA   PCL                      ;Load original pc where JSx is A1H-A2
0737 9F26 85 3D                 STA   A1H                      ;PCL
0738 9F28 A5 3B                 LDA   PCH                      ;
0739 9F2A 85 3E                 STA   A2L                      ;PCH
0740 9F2C AF 2C 01 E1           LDA   >KVAL                    ;
0741 9F30 85 3F                 STA   A2H                      ;
0742 9F32
0743 9F32              *
0744 9F32              * Must preserve the Emulation Stack Pointer in case we are going
0745 9F32              *  off to a native mode stack.  {MSA 4/28/89}
0746 9F32              *
0747 9F32 20 48 7B              JSR   STACKFUTZ                ;{MSA 4/28/89}
0748 9F35              *
0749 9F35                       LONGA ON
0750 9F35                       LONGI ON
0751 9F35 C2 30                 REP   #$30                     ;Off to 16 bit land
0752 9F37 AF 26 01 E1           LDA   >SVAL                    ;Get user stack pointer
0753 9F3B 1B                    TCS                            ;Change to user stack space
0754 9F3C
0755 9F3C                       LONGA OFF
0756 9F3C                       LONGI ON
0757 9F3C E2 20                 SEP   #$20                     ;8/16 M/X            
0758 9F3E A5 3F                 LDA   A2H                      ;Get bank byte where usr reside
0759 9F40 C9 F8                 CMP   #$F8                     ;Is it in ROM bank, $f8-$ff
0760 9F42 90 34                 BCC   NOTROMBK                 ;BRA if not
0761 9F44 64 3D                 STZ   A1H                      ;Start from $ffff of that bank
0762 9F46 64 3E                 STZ   A2L                      ;  
0763 9F48 A0 FF FF              LDY   #$FFFF                   ;
0764 9F4B              GOFORRTL EQU   *
0765 9F4B B7 3D                 LDA   [A1H],Y                  ;Read and test for 'rtl'
0766 9F4D C9 6B                 CMP   #$6B                     ;Search for 'RTL', $6b
0767 9F4F F0 0C                 BEQ   GETRTL
0768 9F51 88                    DEY   
0769 9F52 D0 F7                 BNE   GOFORRTL                 ;If there is no 'rtl', force to step mode
0770 9F54 B7 3A                 LDA   [PCL],Y                  ;Chk for jsr or jsl calls
0771 9F56 C9 22                 CMP   #$22                     ;
0772 9F58 F0 7A                 BEQ   JSLNOTRL                 ;BRA to do jsl routine not in real time
0773 9F5A              JSRNOTRL EQU   *
0774 9F5A 4C 81 A1              JMP   GOJSRL                   ;Single step if no rtl found
0775 9F5D
0776 9F5D              GETRTL   EQU   *
0777 9F5D 4B                    PHK                            ;Get an rtl, save my program bank
0778 9F5E F4 1C A0              PEA   JSLRET-1                 ;Address where rtl returns
0779 9F61 88                    DEY                            ;Adjust the pc for rtl where located
0780 9F62 5A                    PHY                            ;Push in as return address for usr's rts
0781 9F63                       LONGA OFF
0782 9F63                       LONGI OFF
0783 9F63 E2 30                 SEP   #$30                     ;off to 8-bit m/x
0784 9F65 A0 00                 LDY   #$00                     ;Chk for jsr or jsl ?
0785 9F67 B7 3A                 LDA   [PCL],Y                  ;Read in the opcode
0786 9F69 C9 22                 CMP   #$22                     ;Chk for jsl ?
0787 9F6B D0 03                 BNE   @1                       ;Bra if NOT prodos mli
0788 9F6D 4C EE 9F              JMP   ROMJSL                   ;Broke the branch {MSA 4/28/89}
0789 9F70              @1       EQU   *
0790 9F70 A5 3F                 LDA   A2H                      ;Else need to push in usr's program bank
0791 9F72 48                    PHA   
0792 9F73 A0 02                 LDY   #$02                     ;Set proper index for doing jsr
0793 9F75 4C FD 9F              JMP   ROMJSR                   ;Bra to do real time jsr routine
0794 9F78
0795 9F78              NOTROMBK EQU   *
0796 9F78                       LONGA OFF
0797 9F78                       LONGI OFF
0798 9F78 E2 30                 SEP   #$30
0799 9F7A A4 2F                 LDY   LENGTH                   ;'FIXPC' depends on length to get next pc
0800 9F7C 20 7B AC              JSR   FIXPC                    ;Pre-cal next pc, take care of bk crossing
0801 9F7F
0802 9F7F A0 00                 LDY   #$00                     ;Index to pre-read next opcode
0803 9F81 20 8B B4              JSR   READPCY                  ;Read it
0804 9F84 48                    PHA                            ;Save to stack for later restoring
0805 9F85 A9 6B                 LDA   #$6B                     ;Modified user's next opcode w/ 'RTL'
0806 9F87 97 3A                 STA   [PCL],Y                  ;Store the modified code to user next pc
0807 9F89 4B                    PHK                            ;Save monitor program bank
0808 9F8A F4 0F A0              PEA   JSRRET-1                 ;Save return address
0809 9F8D              *
0810 9F8D              * The RESTOREFF scheme for restoring the user's interrupt state has a fundamental
0811 9F8D              *  problem.  You can't just restore the E and I bits when running code in bank <>$00.
0812 9F8D              *  If E=1 and an interrupt comes in, control is lost upon return from the interrupt.
0813 9F8D              *  So we have altered RESTOREFF so that it disables interrupts, and every 
0814 9F8D              *  call to RESTOREFF has been modified so that control is transferred with an RTI,
0815 9F8D              *  so that interrupts are not enabled until after control is transferred. {MSA/FAB 4/12/89}
0816 9F8D              *
0817 9F8D              ; JSR RESTOREFF ;Restore user's environment stuff
0818 9F8D              ; JML [A1H] ;Execute from usr's JSR or JSL itself
0819 9F8D              *
0820 9F8D              * Already in 8 bit mode!
0821 9F8D              *
0822 9F8D AF 32 01 E1           LDA   >EPVAL                   ;If user in native, RTI will pull 4 bytes
0823 9F91 D0 03                 BNE   MF1                      ;If emulation, RTI pulls 3 bytes
0824 9F93 A5 3F                 LDA   A2H                      ;Get the bank part of the address
0825 9F95 48                    PHA                            ; and push it on
0826 9F96              MF1      EQU   *
0827 9F96 A5 3E                 LDA   A2L                      ;Get bits 8..15 of the address
0828 9F98 48                    PHA   
0829 9F99 A5 3D                 LDA   A1H                      ;Get bits 0..7 of the address
0830 9F9B 48                    PHA   
0831 9F9C              MFRTI    EQU   *
0832 9F9C AF 2A 01 E1           LDA   >PVAL                    ;Get the User's status reg
0833 9FA0 48                    PHA                            ; and set up for the RTI
0834 9FA1 AF 32 01 E1           LDA   >EPVAL                   ;Emulation RTI MUST happen from bank $00
0835 9FA5 D0 04                 BNE   @1
0836 9FA7 20 68 7A              JSR   RESTOREFF                ;Restore everything except the PSReg
0837 9FAA 40                    RTI   
0838 9FAB              @1       EQU   *
0839 9FAB 20 68 7A              JSR   RESTOREFF
0840 9FAE 5C 72 C0 00           JMP   >RTI~Bnk00
0841 9FB2              *
0842 9FB2              *
0843 9FB2              JSLSTUFF EQU   *
0844 9FB2 20 8B B4              JSR   READPCY                  ;Y=3, get bank byte
0845 9FB5 C9 E1                 CMP   #^PRO16MLI               ;Test bank byte for PRODOS16 MLI call
0846 9FB7 D0 18                 BNE   NOTMLI16                 ;Bra if not
0847 9FB9 88                    DEY                            ;
0848 9FBA 20 8B B4              JSR   READPCY                  ;Y=2, get high byte
0849 9FBD C9 00                 CMP   #>PRO16MLI               ;Test high byte for PRODOS16 MLI call
0850 9FBF D0 10                 BNE   NOTMLI16
0851 9FC1 88                    DEY   
0852 9FC2 20 8B B4              JSR   READPCY                  ;Y=1, get low byte
0853 9FC5 C9 A8                 CMP   #<PRO16MLI               ;Test low byte for PRODOS16 MLI call
0854 9FC7 D0 08                 BNE   NOTMLI16                 ;Bra if not
0855 9FC9 A9 09                 LDA   #$09
0856 9FCB 85 2F                 STA   LENGTH                   ;Store back, good for 'FIXPC' 
0857 9FCD 68                    PLA                            ;Clean stack
0858 9FCE 4C 24 9F              JMP   MLICALL                  ;PRODOS16 MLI call
0859 9FD1
0860 9FD1              NOTMLI16 EQU   *
0861 9FD1 28                    PLP                            ;Is it force to do real time for any JSL
0862 9FD2 90 0C                 BCC   JSLREAL                  ;BRA if it is
0863 9FD4              JSLNOTRL EQU   *
0864 9FD4                       LONGA OFF
0865 9FD4                       LONGI OFF
0866 9FD4 E2 30                 SEP   #$30
0867 9FD6 AF 2C 01 E1           LDA   >KVAL                    ;Normal JSL step/trace, push pck to stack
0868 9FDA 20 AE A2              JSR   DECSP                    ;Do it and adjust user's SVAL
0869 9FDD 4C 81 A1              JMP   GOJSRL                   ;Go for normal JSL stuff
0870 9FE0
0871 9FE0              JSLREAL  EQU   *
0872 9FE0              *
0873 9FE0              * Must preserve the Emulation Stack Pointer in case we are going
0874 9FE0              *  off to a native mode stack.  {MSA 4/28/89}
0875 9FE0              *
0876 9FE0 20 48 7B              JSR   STACKFUTZ                ;{MSA 4/28/89}
0877 9FE3              *
0878 9FE3                       LONGA ON
0879 9FE3                       LONGI ON
0880 9FE3 C2 30                 REP   #$30                     ;Off to 16 bit land
0881 9FE5 AF 26 01 E1           LDA   >SVAL                    ;Get user stack pointer
0882 9FE9 1B                    TCS                            ;Swap to user stack space
0883 9FEA 4B                    PHK                            ;Save monitor program bank
0884 9FEB F4 1C A0              PEA   JSLRET-1                 ;Save return address on stack
0885 9FEE
0886 9FEE              *
0887 9FEE              * We'll use an RTI to transfer control and to enable interrupts only upon transfer.
0888 9FEE              *  {MSA/FAB 4/12/89}
0889 9FEE              ROMJSL   EQU   *
0890 9FEE                       LONGA OFF
0891 9FEE                       LONGI OFF
0892 9FEE E2 30                 SEP   #$30                     ;Back to 8 bit land
0893 9FF0 A0 03                 LDY   #$3
0894 9FF2 AF 32 01 E1           LDA   >EPVAL                   ;{MSA 4/12} Will it be a emul or native RTI
0895 9FF6 D0 04                 BNE   BACKIN                   ;{MSA 4/12} Emul skip pushing the high byte
0896 9FF8 20 8B B4              JSR   READPCY                  ;Read bank byte
0897 9FFB 48                    PHA                            ;Save on stack
0898 9FFC              BACKIN   EQU   *
0899 9FFC 88                    DEY   
0900 9FFD
0901 9FFD              ROMJSR   EQU   *
0902 9FFD 20 8B B4              JSR   READPCY                  ;Read high byte
0903 A000 48                    PHA   
0904 A001 88                    DEY   
0905 A002 20 8B B4              JSR   READPCY                  ;Read low byte
0906 A005 EB                    XBA                            ;Save pcl to high 'a'
0907 A006 68                    PLA                            ;Get back high byte
0908 A007 EB                    XBA                            ;Make it pch/pcl
0909 A008                       LONGA ON
0910 A008                       LONGI ON
0911 A008 C2 30                 REP   #$30                     ;16 bit land 
0912 A00A              ;DEC A ;Minus 1, when RTL it plus 1
0913 A00A 48                    PHA                            ;Save forward address on stack
0914 A00B                       LONGA OFF
0915 A00B                       LONGI OFF
0916 A00B E2 30                 SEP   #$30                     ;Back to 8 bit land
0917 A00D              ; JSR RESTOREFF ;Restore user's environment first
0918 A00D              ; RTL  ;Off to usr's routine
0919 A00D 4C 9C 9F              JMP   MFRTI                    ;{MSA 4/12} Push user's P, restore and RTI
0920 A010              *
0921 A010              JSRRET   EQU   *                        ;Return after real time jsr routine
0922 A010 20 CE 7A              JSR   STOREFF                  ;Need to store user's new stuff first
0923 A013                       LONGA OFF
0924 A013                       LONGI OFF
0925 A013 E2 30                 SEP   #$30                     ;Set 8 bit land, in case user change it
0926 A015 68                    PLA                            ;Restore the pre-get opcode
0927 A016 A0 00                 LDY   #$0                      ;Prepare index for saving back
0928 A018 97 3A                 STA   [PCL],Y                  ;Store back to the user original area
0929 A01A 4C 0F A2              JMP   XEND                     ;Back to step/trace, no need to update PC
0930 A01D
0931 A01D                                                      ; SEG $FF
0932 A01D              JSLRET   EQU   *                        ;Get here after usr's real time JSL 
0933 A01D                                                      ; SEG $00
0934 A01D 20 CE 7A              JSR   STOREFF                  ;Store user's stuff before anything else
0935 A020                       LONGA OFF
0936 A020                       LONGI OFF
0937 A020 E2 30                 SEP   #$30                     ;Set to 8 bit land in case user change it
0938 A022 4C 03 A2              JMP   XEND2                    ;Back to step/trace, need to update for PC
0939 A025
0940 A025              STEPTR   EQU   *
0941 A025                       LONGA ON
0942 A025                       LONGI ON
0943 A025 C2 30                 REP   #$30                     ;Off to 16 bit land
0944 A027 4B                    PHK                            ;Save return info on stack for 'RTL' after a step
0945 A028 F4 BB 9D              PEA   STEPMORE-1               ;Step more, back to monitor
0946 A02B 3B                    TSC                            ;Save sp where step/trace left off
0947 A02C 8F 8C 01 E1           STA   >STEPSP                  ;Store for returning after each step/trace
0948 A030
0949 A030                       LONGA OFF
0950 A030                       LONGI OFF
0951 A030 E2 30                 SEP   #$30                     ;Off to 8 bit land
0952 A032
0953 A032
0954 A032              *
0955 A032              * User's instruction filtering and execution
0956 A032              *
0957 A032 78                    SEI                            ;Disable interrupt
0958 A033 A0 00                 LDY   #$0                      ;Set index to read opcode at PC
0959 A035 20 8B B4              JSR   READPCY                  ;Read an opcode                  
0960 A038 48                    PHA                            ;Temp store the opcode
0961 A039 A2 0B                 LDX   #$0B                     ;Init execution area
0962 A03B              XQINIT   EQU   *
0963 A03B BF 43 A2 FF           LDA   >XOPC,X                  ;Absolute long index
0964 A03F 9F C3 01 E1           STA   >USEROPC,X               ;Save to step/trace execution area
0965 A043 CA                    DEX   
0966 A044 10 F5                 BPL   XQINIT                   ;Till done
0967 A046
0968 A046 AF 3E 01 E1           LDA   >BANKS                   ;Get usr's bank
0969 A04A 85 3C                 STA   A1L                      ;Store so that pcl/pch/a1l=pcl/pch/pck
0970 A04C 8F 2C 01 E1           STA   >KVAL                    ;Also update usr's program bank
0971 A050
0972 A050 FA                    PLX                            ;Restore opcode and store in 'x'
0973 A051 D0 10                 BNE   NOTBRK                   ;If brk, exit to monitor    
0974 A053              SPERR    EQU   *
0975 A053 20 51 9A              JSR   NEWBELL1                 ;Beep
0976 A056 AF BA 01 E1           LDA   >JSX
0977 A05A 29 BF                 AND   #$BF                     ;Set bit6=0
0978 A05C 8F BA 01 E1           STA   >JSX
0979 A060 4C 0F A2              JMP   XEND                     ;Exit and stay to brk
0980 A063
0981 A063              NOTBRK   EQU   *
0982 A063 E0 60                 CPX   #$60                     ;RTS ?
0983 A065 F0 0F                 BEQ   XRTS
0984 A067 E0 6B                 CPX   #$6B                     ;RTL ?
0985 A069 F0 0B                 BEQ   XRTS
0986 A06B E0 40                 CPX   #$40                     ;RTI ?
0987 A06D D0 37                 BNE   XQ1                      ;Bra if not RTI
0988 A06F 20 8D A2              JSR   INCSP                    ;Check user sp and return the value pointed by sp in 'A'
0989 A072 8F 2A 01 E1           STA   >PVAL                    ;Simulate rti by getting 'p' from stack  
0990 A076              XRTS     EQU   *                        ;Simulate for rts
0991 A076 20 8D A2              JSR   INCSP                    ;Update new pch/pcl with new values from user's stack
0992 A079 85 3A                 STA   PCL                      ;Store to pcl
0993 A07B 20 8D A2              JSR   INCSP                    ;Read next value in sp+1
0994 A07E 85 3B                 STA   PCH                      ;Store to pch
0995 A080 E0 40                 CPX   #$40
0996 A082              *BEQ XRTS1 ;For RTI, there is no plus 1 for value from stack
0997 A082              *
0998 A082              * Fix a bug where a native mode RTI was not pulling the PBR off
0999 A082              *  of the stack.  {MSA 4/10/89}
1000 A082              *
1001 A082 D0 08                 BNE   MXRTS                    ;Skip if not an RTI
1002 A084 AF 32 01 E1           LDA   >EPVAL                   ;RTI's behavior depends on E
1003 A088 F0 0C                 BEQ   PIARTL                   ;Native RTI- pretend RTL- PBR on stk
1004 A08A 80 17                 BRA   XRTS1                    ;Emulation RTI doesn't have PBR on stack
1005 A08C              MXRTS    EQU   *
1006 A08C              *
1007 A08C              * End of 4/10/89 patch  {MSA}
1008 A08C              *
1009 A08C                       LONGA ON
1010 A08C                       LONGI ON
1011 A08C C2 30                 REP   #$30                     ;16 bit 'm'/'x'
1012 A08E E6 3A                 INC   PCL                      ;For RTS/RTL, return address in stack + 1 = new PC
1013 A090                       LONGA OFF
1014 A090                       LONGI OFF
1015 A090 E2 30                 SEP   #$30                     ;Back to 8 bit land
1016 A092
1017 A092 E0 6B                 CPX   #$6B                     ;RTL ? 
1018 A094 D0 0D                 BNE   XRTS1                    ;Bra if not               
1019 A096              PIARTL   EQU   *                        ;Pull the PBR off the stack {MSA 4/10/89}
1020 A096 20 8D A2              JSR   INCSP                    ;Else to pull one more for program bank
1021 A099 8F 2C 01 E1           STA   >KVAL                    ;Update user's program bank
1022 A09D 8F 3E 01 E1           STA   >BANKS
1023 A0A1 85 3C                 STA   A1L
1024 A0A3              XRTS1    EQU   *
1025 A0A3 4C 0F A2              JMP   XEND                     ;Regs display and back to next step/trace
1026 A0A6
1027 A0A6
1028 A0A6              XQ1      EQU   *
1029 A0A6 DA                    PHX                            ;Save the user's opcode
1030 A0A7 A4 2F                 LDY   LENGTH                   ;Get length of opcode
1031 A0A9              XQ2      EQU   *
1032 A0A9 20 8B B4              JSR   READPCY                  ;Read usr's opcode & oprnd, preserve x/y
1033 A0AC BB                    TYX                            ;Try to do index long w/ 'x'
1034 A0AD 9F C3 01 E1           STA   >USEROPC,X               ;Copy to execution area
1035 A0B1 88                    DEY   
1036 A0B2 10 F5                 BPL   XQ2                      ;Move until done
1037 A0B4 FA                    PLX                            ;Restore usr's opcode
1038 A0B5
1039 A0B5              XQ3      EQU   *
1040 A0B5              *
1041 A0B5              * Add a check for 'CLI' to disable its execution {MSA 3/30/89}
1042 A0B5              *
1043 A0B5 E0 58                 CPX   #$58                     ;Defeat CLI emulation...
1044 A0B7 D0 03                 BNE   noprob
1045 A0B9 4C 0A A2              JMP   XEND1
1046 A0BC              NOPROB   EQU   *
1047 A0BC              *
1048 A0BC              ******** END 3/30/89 PATCH *********
1049 A0BC              *
1050 A0BC E0 4C                 CPX   #$4C                     ;JMP....?
1051 A0BE B0 03                 BCS   @3                       ;Bra if could be a JMP, JMP (), JML
1052 A0C0 4C 6F A1              JMP   XJSR1                    ;Else check for JSR...
1053 A0C3              @3       EQU   *
1054 A0C3 F0 30                 BEQ   XJMP                     ;Bra for JMP a
1055 A0C5 E0 DC                 CPX   #$DC
1056 A0C7 F0 2C                 BEQ   XJMP                     ;JML (a)
1057 A0C9 90 03                 BCC   @2                       ;Bra if could be a JMP, JMP ()
1058 A0CB              @4       EQU   *
1059 A0CB 4C 6F A1              JMP   XJSR1                    ;Else check for JSR..
1060 A0CE              @2       EQU   *
1061 A0CE E0 5C                 CPX   #$5C
1062 A0D0 F0 23                 BEQ   XJMP                     ;JMP al
1063 A0D2 E0 6C                 CPX   #$6C
1064 A0D4 F0 1F                 BEQ   XJMP                     ;JMP (a)
1065 A0D6 E0 7C                 CPX   #$7C
1066 A0D8 D0 F1                 BNE   @4                       ;Bra if not JMP (a,x)
1067 A0DA AF 32 01 E1           LDA   >EPVAL                   ;Check user's 'e'
1068 A0DE D0 08                 BNE   @1                       ;Bra if e=1, emulation mode
1069 A0E0 AF 2A 01 E1           LDA   >PVAL                    ;If e=0, need to check index 'x' mode
1070 A0E4 29 10                 AND   #$10
1071 A0E6 F0 0D                 BEQ   XJMP                     ;Bra if INDEX16 MODE  
1072 A0E8              @1       EQU   *
1073 A0E8 AF 23 01 E1           LDA   >XVAL+1                  ;Get user's low byte 'x'
1074 A0EC 48                    PHA                            ;Store to stack so XVAL can be manipulated
1075 A0ED A9 00                 LDA   #0                       ;With index8, set high byte of 'x' to 0
1076 A0EF 8F 23 01 E1           STA   >XVAL+1
1077 A0F3 80 05                 BRA   XJMPP                    ;                                      
1078 A0F5
1079 A0F5              XJMP     EQU   *
1080 A0F5 AF 23 01 E1           LDA   >XVAL+1                  ;Get user's XVAL+1
1081 A0F9 48                    PHA                            ;Store it                               
1082 A0FA              XJMPP    EQU   *
1083 A0FA AF C4 01 E1           LDA   >USEROPRL                ;Get user's operand low
1084 A0FE 85 3A                 STA   PCL                      ;Store as new pcl
1085 A100 AF C5 01 E1           LDA   >USEROPRH                ;Get user's operand high
1086 A104 85 3B                 STA   PCL+1                    ;Store as new pch
1087 A106 E0 5C                 CPX   #$5C                     ;JMP al ?
1088 A108 D0 0C                 BNE   XJMP1                    ;Bra if not JSL
1089 A10A AF C6 01 E1           LDA   >USEROPRK                ;Else need to update program bank
1090 A10E 8F 3E 01 E1           STA   >BANKS                   ;Store it
1091 A112 8F 2C 01 E1           STA   >KVAL                    ;Store to user program bank location
1092 A116
1093 A116              XJMP1    EQU   *
1094 A116 E0 4C                 CPX   #$4C
1095 A118 F0 4D                 BEQ   GOXEND                   ;JMP A
1096 A11A E0 5C                 CPX   #$5C
1097 A11C F0 49                 BEQ   GOXEND                   ;JMP al
1098 A11E
1099 A11E E0 7C                 CPX   #$7C
1100 A120 D0 0D                 BNE   XJMPai                   ;Bra for JMP (a) or JMl (a)
1101 A122                       LONGA ON
1102 A122                       LONGI ON
1103 A122 C2 30                 REP   #$30                     ;Off to 16 bit land
1104 A124 AF C4 01 E1           LDA   >USEROPRL                ;Get user's oprh/oprl
1105 A128 18                    CLC                            ;Set 'c'=0
1106 A129 6F 22 01 E1           ADC   >XVAL                    ;Add in 'x' register offset, (a,x)
1107 A12D 85 3A                 STA   PCL                      ;Store as new pch/pcl
1108 A12F
1109 A12F              XJMPAI   EQU   *
1110 A12F                       LONGA OFF
1111 A12F                       LONGI OFF
1112 A12F E2 30                 SEP   #$30                     ;Off to 8 bit land
1113 A131 E0 DC                 CPX   #$DC                     ;JML (a) ?
1114 A133 D0 0C                 BNE   XJMPai1
1115 A135 A0 02                 LDY   #$2                      ;Set y=2 to read pck
1116 A137 B1 3A                 LDA   (PCL),Y                  ;Get the new pck        
1117 A139 8F 3E 01 E1           STA   >BANKS                   ;Store it
1118 A13D 8F 2C 01 E1           STA   >KVAL                    ;Store to user's program bank location
1119 A141              XJMPAI1  EQU   *
1120 A141              *
1121 A141              * This code has 6C,7C,DC, and FC opcodes passing thru.  In the case
1122 A141              *  of 6C and DC the location where the indirect address lies is in
1123 A141              *  bank $00.  In the case of FC and 7C it is in the User's Current
1124 A141              *  program bank.  {MSA/FAB 4/26/89}
1125 A141              *
1126 A141 E0 FC                 CPX   #$FC                     ;Check for JSR (a,x)
1127 A143 F0 04                 BEQ   @1
1128 A145 E0 7C                 CPX   #$7C                     ;Check for JMP (a,x)
1129 A147 D0 13                 BNE   @2                       ;Bank defaults to $00
1130 A149              *
1131 A149              @1       EQU   *
1132 A149 8B                    PHB   
1133 A14A AF 2C 01 E1           LDA   >KVAL                    ;Get user's pgm bank
1134 A14E 48                    PHA                            ;Xfer to our data bank reg for lda below
1135 A14F AB                    PLB   
1136 A150                       LONGA ON
1137 A150                       LONGI ON
1138 A150 C2 30                 REP   #$30                     ;Get 16 bits of effective address
1139 A152 A0 00 00              LDY   #$0000
1140 A155 B1 3A                 LDA   (PCL),Y                  ;Get effective address
1141 A157 85 3A                 STA   PCL                      ;Replace pointer
1142 A159 AB                    PLB                            ;Our old program bank
1143 A15A 80 09                 BRA   @3
1144 A15C              @2       EQU   *
1145 A15C                       LONGA ON
1146 A15C                       LONGI ON
1147 A15C C2 30                 REP   #$30                     ;Off to 16 bit land
1148 A15E A0 00 00              LDY   #$0
1149 A161 B1 3A                 LDA   (PCL),Y                  ;Get the new pc with the adjusting offset
1150 A163 85 3A                 STA   PCL                      ;Store to pch/pcl
1151 A165                       LONGA OFF
1152 A165                       LONGI OFF
1153 A165              @3       EQU   *
1154 A165 E2 30                 SEP   #$30                     ;Back to 8 bit land
1155 A167
1156 A167              GOXEND   EQU   *
1157 A167 68                    PLA                            ;Retrieve user's XVAL+1
1158 A168 8F 23 01 E1           STA   >XVAL+1                  ;Store back 
1159 A16C 4C 0F A2              JMP   XEND                     ;End of JMP..., back to step/trace world
1160 A16F
1161 A16F              XJSR1    EQU   *
1162 A16F 38                    SEC                            ;'c'=1, as an indicator
1163 A170 08                    PHP                            ;Save for later use                      
1164 A171 E0 20                 CPX   #$20                     ;JSR a ?
1165 A173 F0 04                 BEQ   @1                       ;          
1166 A175 E0 22                 CPX   #$22                     ;JSL ?
1167 A177 D0 03                 BNE   @2                       ;Bra to check others                     
1168 A179              @1       EQU   *
1169 A179 4C 00 9F              JMP   NOTREAL                  ;Jmp to check for PRODOS MLI call
1170 A17C
1171 A17C              @2       EQU   *
1172 A17C 28                    PLP                            ;Clean stack
1173 A17D E0 FC                 CPX   #$FC                     ;JSR (a,x) ?
1174 A17F D0 25                 BNE   XBRA                     ;Bra to check for 'BRANCH' instruction
1175 A181              GOJSRL   EQU   *
1176 A181 DA                    PHX                            ;Save opcode
1177 A182 C6 2F                 DEC   LENGTH                   ;Make return address = next pc - 1
1178 A184 20 53 F9              JSR   PCADJ                    ;Adjust for new pc-1   
1179 A187 85 3A                 STA   PCL                      ;User return address after JSx
1180 A189 84 3B                 STY   PCH
1181 A18B 48                    PHA                            ;'A'= new pcl
1182 A18C 98                    TYA                            ;'Y'= new pch
1183 A18D 20 AE A2              JSR   DECSP                    ;Save pch/pcl-1 onto stack
1184 A190 68                    PLA                            ;Get back pcl
1185 A191 20 AE A2              JSR   DECSP
1186 A194 A2 4C                 LDX   #$4C                     ;Simulate jsr....by jmp
1187 A196 68                    PLA                            ;Retrieve opcode
1188 A197 C9 20                 CMP   #$20
1189 A199 F0 08                 BEQ   GOJMP                    ;$20 -> $4C
1190 A19B A2 5C                 LDX   #$5C
1191 A19D C9 22                 CMP   #$22
1192 A19F F0 02                 BEQ   GOJMP                    ;$22 -> $5C
1193 A1A1 A2 7C                 LDX   #$7C                     ;$FC -> $7C
1194 A1A3
1195 A1A3              GOJMP    EQU   *
1196 A1A3 4C F5 A0              JMP   XJMP                     ;Simulate JSx w/ JMx after conversion
1197 A1A6
1198 A1A6
1199 A1A6              XBRA     EQU   *
1200 A1A6 E0 82                 CPX   #$82                     ;Is it brl ?
1201 A1A8 D0 0A                 BNE   XQ4                      ;Bra if no
1202 A1AA A9 00                 LDA   #$00                     ;Make 'a'=0
1203 A1AC 8F C5 01 E1           STA   >USEROPRH                ;Set to zero
1204 A1B0                       LONGA OFF
1205 A1B0 A9 05                 LDA   #XBRANCH-XOPRK           ;Get offset for 'BRANCH'
1206 A1B2 80 0D                 BRA   SETOPRL
1207 A1B4              XQ4      EQU   *
1208 A1B4 E0 80                 CPX   #$80                     ;Is it bra ?
1209 A1B6 F0 07                 BEQ   SETOFFSET                ;
1210 A1B8 8A                    TXA                            ;Get back opcode
1211 A1B9 29 1F                 AND   #$1F                     ;Make 'Branch' bra to 'JMP BRANCH'
1212 A1BB C9 10                 CMP   #$10
1213 A1BD D0 06                 BNE   XQ5                      ;Bra for inst except RTx, JMx, JSx, BRANCH
1214 A1BF              SETOFFSET EQU   *
1215 A1BF                       LONGA OFF
1216 A1BF A9 06                 LDA   #XBRANCH-XOPRH           ;Calculate offset 
1217 A1C1              SETOPRL  EQU   *
1218 A1C1 8F C4 01 E1           STA   >USEROPRL                ;Store to useroprl
1219 A1C5
1220 A1C5              XQ5      EQU   *
1221 A1C5 E0 62                 CPX   #$62                     ;Is it 'PER'
1222 A1C7 F0 0D                 BEQ   XQ6
1223 A1C9 E0 4B                 CPX   #$4B                     ;PHK ?
1224 A1CB D0 20                 BNE   USERINST                 ;Bra for other normal instructions
1225 A1CD AF 2C 01 E1           LDA   >KVAL                    ;Special PHK, need to save pck to stack
1226 A1D1 20 AE A2              JSR   DECSP                    ;Do it and adjust sp also
1227 A1D4 80 34                 BRA   XEND1                    ;Bra to end and back to step/trace world
1228 A1D6
1229 A1D6              XQ6      EQU   *
1230 A1D6              *
1231 A1D6              * Must preserve the Emulation Stack Pointer in case we are going
1232 A1D6              *  off to a native mode stack.  {MSA 4/28/89}
1233 A1D6              *
1234 A1D6 20 48 7B              JSR   STACKFUTZ                ;{MSA 4/28/89}
1235 A1D9              *
1236 A1D9                       LONGA ON                       	;16-bit m/x
1237 A1D9                       LONGI ON
1238 A1D9 C2 30                 REP   #$30
1239 A1DB AF 26 01 E1           LDA   >SVAL                    ;Get user sp
1240 A1DF 1B                    TCS                            ;So simulate of 'PER' is in user stk space
1241 A1E0 A5 3A                 LDA   PCL                      ;Get current address
1242 A1E2 1A                    INC   A                        ;Offset by 2
1243 A1E3 1A                    INC   A
1244 A1E4 38                    SEC                            ;Make it correct addition    
1245 A1E5 6F C4 01 E1           ADC   >USEROPRL                ;Add in offset
1246 A1E9 48                    PHA                            ;Save to user stack space
1247 A1EA 80 17                 BRA   XEND2                    ;Jmp to set new SVAL and ret to step/trace
1248 A1EC 48                    PHA   
1249 A1ED
1250 A1ED              USERINST EQU   *
1251 A1ED              *
1252 A1ED              * Must preserve the Emulation Stack Pointer in case we are going
1253 A1ED              *  off to a native mode stack.  {MSA 4/28/89}
1254 A1ED              *
1255 A1ED 20 48 7B              JSR   STACKFUTZ                ;{MSA 4/28/89}
1256 A1F0              *
1257 A1F0                       LONGA ON
1258 A1F0                       LONGI ON
1259 A1F0 C2 30                 REP   #$30                     ;Off to 16 bit land
1260 A1F2 AF 26 01 E1           LDA   >SVAL                    ;Get back user stack pointer
1261 A1F6 1B                    TCS                            ;Do it and use usr stk space until restore step/trace sp
1262 A1F7                       LONGA OFF
1263 A1F7                       LONGI OFF
1264 A1F7 E2 30                 SEP   #$30                     ;Back to 8 bit land
1265 A1F9
1266 A1F9              ;
1267 A1F9              ; From restore to execute then store back, it would hope the 
1268 A1F9              ; user stack pointer and processor status not be changed, but
1269 A1F9              ; somehow the stack space has been touched
1270 A1F9              ;
1271 A1F9              *
1272 A1F9              * Note that interrupts will be forced off by RESTOREFF.  Can't have
1273 A1F9              *  them on because we're going to Bank $E1 and the user might have
1274 A1F9              *  E=1 {MSA 4/12/89}
1275 A1F9              *
1276 A1F9 20 68 7A              JSR   RESTOREFF                ;Restore user environment and registers 
1277 A1FC 5C C3 01 E1           JMP   >USEROPC                 ;Jmp to execute user instruction
1278 A200              *
1279 A200                                                      ; SEG $FF
1280 A200              NOBRANCH EQU   *
1281 A200                                                      ; SEG $00
1282 A200 20 CE 7A              JSR   STOREFF                  ;Use usr stk area, return w/ native mode
1283 A203
1284 A203              XEND2    EQU   *
1285 A203                       LONGA ON
1286 A203                       LONGI ON
1287 A203 C2 30                 REP   #$30                     ;Off to 16 bit land
1288 A205 3B                    TSC                            ;Save user's stack pointer
1289 A206 8F 26 01 E1           STA   >SVAL                    ;Store for display
1290 A20A
1291 A20A              XEND1    EQU   *
1292 A20A                       LONGA OFF
1293 A20A                       LONGI OFF
1294 A20A E2 30                 SEP   #$30                     ;Back to 8 bit land
1295 A20C 20 7B AC              JSR   FIXPC                    ;After each instruction, adjust pc for next
1296 A20F              XEND     EQU   *
1297 A20F              *
1298 A20F              * Must restore the emulation stack pointer in case we changed it.
1299 A20F              *  {MSA 4/28/89}
1300 A20F              *
1301 A20F AF CF 01 E1           LDA   >KPMNEMSP                ;{MSA 4/28/89} Get saved value
1302 A213 8F 00 01 01           STA   >MNEMSTKPTR              ;{MSA 4/28/89}
1303 A217              *
1304 A217                       LONGA ON
1305 A217                       LONGI ON
1306 A217 C2 30                 REP   #$30                     ;Off to 16 bit land
1307 A219 AF 8C 01 E1           LDA   >STEPSP                  ;Continue w/ step/trace till 'esc' key
1308 A21D 1B                    TCS                            ;Re-enter monitor stack space
1309 A21E AF 26 01 E1           LDA   >SVAL                    ;Check user stack space
1310 A222 C9 00 02              CMP   #$0200                   ;Not in regular stack area then leave it alone
1311 A225 B0 0D                 BCS   XEND01                   ;Bra if OK
1312 A227 C9 0F 01              CMP   #$010F                   ;In regular stack, is it end of the stk?
1313 A22A B0 08                 BCS   XEND01                   ;If not that close, still OK
1314 A22C                       LONGA OFF
1315 A22C                       LONGI OFF
1316 A22C E2 30        TOMON1   SEP   #$30
1317 A22E 20 51 9A              JSR   NEWBELL1                 ;Beep it
1318 A231 4C B4 9E              JMP   TOMON                    ;Stack tragedy, exit to monitor
1319 A234
1320 A234              XEND01   EQU   *
1321 A234                       LONGA OFF
1322 A234                       LONGI OFF
1323 A234 E2 30                 SEP   #$30                     ;Back to 8 bit land
1324 A236 AF BA 01 E1           LDA   >JSX                     ;Chk regs display on/off options
1325 A23A 29 40                 AND   #$40                     ;Mask for bit6         
1326 A23C D0 03                 BNE   @2                       ;BRA if no need to display regs
1327 A23E 20 ED A4              JSR   REGDSP2                  ;Make a regs and status display after an instruction
1328 A241              @2       EQU   *
1329 A241 58                    CLI                            ;Enable interrupt
1330 A242 6B                    RTL                            ;Ret to STEPMORE to continue in step mode
1331 A243
1332 A243                                                      ; SEG $FF
1333 A243              XOPC     EQU   *
1334 A243                                                      ; SEG $00
1335 A243 EA                    NOP                            ;XOPC, opcode
1336 A244              XOPRL    EQU   *
1337 A244 EA                    NOP                            ;XOPRL, operand (L) of opcode
1338 A245              XOPRH    EQU   *
1339 A245 EA                    NOP                            ;XOPRH, operand (H) of opcode
1340 A246              XOPRK    EQU   *
1341 A246 EA                    NOP                            ;Bank byte, operand (K) of opcode
1342 A247 5C 00 A2 FF           JMP   >NOBRANCH                ;Jump to handle nobranch instruction
1343 A24B              XBRANCH  EQU   *
1344 A24B 5C 53 A2 FF           JMP   >BRANCH                  ;Jump to handle branch instruction
1345 A24F                                                      ; SEG $FF
1346 A24F              RETMLI   EQU   *
1347 A24F                                                      ; SEG $00
1348 A24F 5C 1D A0 FF           JMP   >JSLRET                  ;Return from MLI16 call
1349 A253              *
1350 A253
1351 A253                                                      ; SEG $FF
1352 A253              BRANCH   EQU   *
1353 A253                                                      ; SEG $00
1354 A253 F4 00 00              PEA   $0000                    ;Set back monitor data bank in case user change it
1355 A256 AB                    PLB   
1356 A257 AB                    PLB   
1357 A258 F4 00 00              PEA   $0000                    ;Reset direct register also
1358 A25B 2B                    PLD   
1359 A25C 18                    CLC   
1360 A25D FB                    XCE                            ;Native mode, in case user set to emulation mode
1361 A25E                       LONGA OFF
1362 A25E                       LONGI OFF
1363 A25E E2 30                 SEP   #$30                     ;Back to 8 bit land
1364 A260 A4 2F                 LDY   LENGTH                   ;Get 'branch' opcode length, only brl needs 2 bytes
1365 A262 20 8B B4              JSR   READPCY                  ;Read high byte first
1366 A265 88                    DEY                            ;
1367 A266 F0 15                 BEQ   @1                       ;Bra if only one byte offset, e.g. bcs, bvs....
1368 A268 48                    PHA                            ;Save hi byte
1369 A269 20 8B B4              JSR   READPCY                  ;If 2 bytes offset, read in low byte now
1370 A26C 38                    SEC                            ;'c'=1
1371 A26D 65 3A                 ADC   PCL                      ;Adjust PC w/ offset
1372 A26F AA                    TAX                            ;Temp store ocl
1373 A270 68                    PLA                            ;Get back high byte
1374 A271 65 3B                 ADC   PCH                      ;Adjust high byte, 'c'=1
1375 A273 A8                    TAY                            ;Temp save
1376 A274 8A                    TXA                            ;Get back low
1377 A275 18                    CLC                            ;'c'=0
1378 A276 69 02                 ADC   #2                       ;Add 2 more for 2 bytes offset
1379 A278 AA                    TAX                            ;pcl to 'x'
1380 A279 90 0B                 BCC   @3                       ;If 'c'=1, need to adjust high byte by 1
1381 A27B 80 08                 BRA   @2                       ;Else just store
1382 A27D
1383 A27D              @1       EQU   *                        ;One byte offset handling
1384 A27D 38                    SEC                            ;'c'=1
1385 A27E 20 56 F9              JSR   PCADJ3                   ;One byte length pc adjust
1386 A281 AA                    TAX                            ;PCL,PCH+OFFSET+1 TO A,Y
1387 A282 E8                    INX   
1388 A283 D0 01                 BNE   @3
1389 A285              @2       EQU   *
1390 A285 C8                    INY   
1391 A286              @3       EQU   *
1392 A286 86 3A                 STX   PCL                      ;Store it as new pcl
1393 A288 84 3B                 STY   PCH                      ;Store it as new pch
1394 A28A 4C 0F A2              JMP   XEND                     ;End the 'BRANCH' world and return
1395 A28D
1396 A28D              *
1397 A28D
1398 A28D              *
1399 A28D              * RESTOREFF and STOREFF have been moved to the SLOT.ARBITER file {MSA 4/12/89}
1400 A28D              *
1401 A28D
1402 A28D
1403 A28D              INCSP    EQU   *
1404 A28D 8B                    PHB                            ;Save current data bank
1405 A28E 20 82 F8              JSR   DBTOE1                   ;Change data bank to $e1
1406 A291 EE 26 01              INC   |SVAL                    ;SP low byte boundary checking, i.e. $xxff
1407 A294 D0 08                 BNE   LDASP                    ;Bra if not at boundary
1408 A296 AD 32 01              LDA   |EPVAL                   ;Check for emulation/native
1409 A299 F0 03                 BEQ   LDASP                    ;Bra if in emulation mode
1410 A29B EE 26 01              INC   |SVAL                    ;Else adjust hgh byte of stk ptr by 1
1411 A29E              LDASP    EQU   *
1412 A29E AD 26 01              LDA   |SVAL                    ;Copy SVAL/SVAL+1 to A1H-A2L for next addressing mode
1413 A2A1 85 3D                 STA   A1H                      ;Form an direct indirect long
1414 A2A3 AD 27 01              LDA   |SVAL+1
1415 A2A6 85 3E                 STA   A2L                      ;
1416 A2A8 64 3F                 STZ   A2H                      ;Force to $00
1417 A2AA A7 3D                 LDA   [A1H]                    ;Get the value pointed by usr stk pointer
1418 A2AC AB                    PLB                            ;Restore data bank
1419 A2AD 60                    RTS                            ;Back to caller, step/trace of monitor
1420 A2AE
1421 A2AE              DECSP    EQU   *
1422 A2AE 8B                    PHB   
1423 A2AF 48                    PHA                            ;Save 
1424 A2B0 20 82 F8              JSR   DBTOE1
1425 A2B3 AD 26 01              LDA   |SVAL
1426 A2B6 85 3D                 STA   A1H                      ;Copy user stk ptr to monitor direct page
1427 A2B8 AD 27 01              LDA   |SVAL+1                  ; so that an direct indirect long can be used to store pc
1428 A2BB 85 3E                 STA   A2L                      ;
1429 A2BD 68                    PLA   
1430 A2BE 64 3F                 STZ   A2H                      ;Force to $00
1431 A2C0 87 3D                 STA   [A1H]                    ;Save return address to user stack area
1432 A2C2 CE 26 01              DEC   |SVAL                    ;Need to adjust stack pointer
1433 A2C5 AD 26 01              LDA   |SVAL                    ;Check for boundary
1434 A2C8 C9 FF                 CMP   #$FF
1435 A2CA D0 08                 BNE   DECSRRTS
1436 A2CC AD 32 01              LDA   |EPVAL
1437 A2CF D0 03                 BNE   DECSRRTS
1438 A2D1 CE 27 01              DEC   |SVAL+1
1439 A2D4              DECSRRTS EQU   *
1440 A2D4 AB                    PLB   
1441 A2D5 60                    RTS   
1442 A2D6
1443 A2D6
1444 A2D6
1445 A2D6
1446 A2D6                       TITLE 'Misc Monitor Bank FF Rtnes00'
1447 A2D6
1448 A2D6              ******************************************************
1449 A2D6              *                                                    *
1450 A2D6              *        Miscellaneous Monitor Bank FF Routines01    *
1451 A2D6              *                                                    *
1452 A2D6              *                    by                              *
1453 A2D6              *               Fern Bachman     1985-1987           *
1454 A2D6              *               Joe Bo           1987-1989           *
1455 A2D6              *                                                    *
1456 A2D6              *       Copyright Apple Computer, Inc. 1985-1989     *
1457 A2D6              *                All Rights Reserved.                *
1458 A2D6              *                                                    *
1459 A2D6              ******************************************************
1460 A2D6
1461 A2D6              EQUALSFF EQU   *
1462 A2D6 A4 34                 LDY   YSAV                     ;Continue where command parser left off
1463 A2D8              @1       EQU   *
1464 A2D8 B9 00 02              LDA   IN,Y                     ;Ignore spaces and find command
1465 A2DB C9 A0                 CMP   #$A0                     ;
1466 A2DD D0 03                 BNE   @2                       ;<> $A0 then may have something
1467 A2DF C8                    INY                            ;Keep testing
1468 A2E0 D0 F6                 BNE   @1                       ;Loop
1469 A2E2
1470 A2E2              @2       EQU   *
1471 A2E2 C8                    INY                            ;Must be looking at next char in IN
1472 A2E3 84 34                 STY   YSAV                     ;Save pointer
1473 A2E5 A2 12                 LDX   #NEWCMDLEN-1             ;Maximum number of new commands to check
1474 A2E7              @3       EQU   *
1475 A2E7 DF EA C0 FF           CMP   >NEWCMDSTBL,X            ;Check for matches
1476 A2EB F0 69                 BEQ   GOODCMD                  ;
1477 A2ED CA                    DEX                            ;
1478 A2EE 10 F7                 BPL   @3                       ;Loop to try to find one
1479 A2F0
1480 A2F0              * Fall to here if all else fails
1481 A2F0
1482 A2F0 88                    DEY                            ;Offset for INY done in NEWCMDTST earlier
1483 A2F1              @4       EQU   *
1484 A2F1 B9 00 02              LDA   IN,Y                     ;Eat any preceeding spaces
1485 A2F4 C9 A0                 CMP   #SPACE                   ;
1486 A2F6 D0 03                 BNE   @5                       ;<>= then continue normally
1487 A2F8 C8                    INY                            ;
1488 A2F9 80 F6                 BRA   @4                       ;
1489 A2FB
1490 A2FB              @5       EQU   *
1491 A2FB E2 40                 SEP   #$40                     ;Anticipate unsigned conversion requested
1492 A2FD C9 AB                 CMP   #'+'                     ;If '+' or '-' then do signed stuff
1493 A2FF F0 04                 BEQ   @6                       ;
1494 A301 C9 AD                 CMP   #'-'                     ;
1495 A303 D0 01                 BNE   @7                       ;
1496 A305              @6       EQU   *
1497 A305 B8                    CLV                            ;'v'=0 to indicate signed conversion
1498 A306              @7       EQU   *
1499 A306
1500 A306 20 E4 A6              JSR   PUSH6                    ;Push room for result on stack
1501 A309 E2 30                 SEP   #$30                     ;Undo PUSH setting it in to 16 bit mode
1502 A30B A9 02                 LDA   #>IN                     ;High byte of low word of ptr to buffer
1503 A30D 48                    PHA                            ;
1504 A30E 5A                    PHY                            ;Low byte of word of ptr to buffer
1505 A30F A2 00                 LDX   #$00                     ;Count bytes
1506 A311              @8       EQU   *
1507 A311 E8                    INX                            ;Increment count index
1508 A312 C8                    INY                            ;
1509 A313 B9 00 02              LDA   IN,Y                     ;Test for carriage return
1510 A316 C9 8D                 CMP   #$8D                     ;
1511 A318 F0 06                 BEQ   @9                       ;= then continue
1512 A31A 49 B0                 EOR   #$B0                     ;Test for valid decimal entry
1513 A31C C9 0A                 CMP   #$0A                     ;0-9 is OK
1514 A31E 90 F1                 BCC   @8                       ;Loop til end is found
1515 A320              @9       EQU   *
1516 A320 C2 30                 REP   #$30                     ;Go to 16 bit land to make call
1517 A322 DA                    PHX                            ;Push number of bytes to convert
1518 A323 50 05                 BVC   @10                      ;'v'=0 then signed conversion
1519 A325 F4 00 00              PEA   $0000                    ; else unsigned conversion
1520 A328 80 03                 BRA   @11                      ;
1521 A32A
1522 A32A              @10      EQU   *
1523 A32A F4 01 00              PEA   $0001                    ;<>0 for signed conversion
1524 A32D              @11      EQU   *
1525 A32D                       LONGI ON
1526 A32D A2 0B 29              LDX   #DEC2LONG*256+IMTN       ;Function number*256+tool number
1527 A330                       LONGI OFF
1528 A330 22 00 00 E1           JSL   >DISPATCH1               ;Call tool locator
1529 A334 E2 30                 SEP   #$30                     ;Back to monitor mode
1530 A336 A9 09                 LDA   #HEXMSG                  ;Print 'Hex-> $'
1531 A338 20 80 C0              JSR   PRINTMSG                 ;
1532 A33B A3 03                 LDA   3,S                      ;Low byte of high word
1533 A33D AA                    TAX                            ;
1534 A33E A3 04                 LDA   4,S                      ;High byte of high word
1535 A340 20 9F A9              JSR   PRNTAXFF                 ;Print em
1536 A343 FA                    PLX                            ;Low byte of low word
1537 A344 68                    PLA                            ;High byte of low word
1538 A345 20 9F A9              JSR   PRNTAXFF                 ;Print em
1539 A348 68                    PLA                            ;Clean up stack
1540 A349 68                    PLA                            ;
1541 A34A
1542 A34A
1543 A34A              DECTOHEX6 EQU   *
1544 A34A 20 52 AC              JSR   LIST3                    ;Next line+space please
1545 A34D
1546 A34D              * To return directly to the monitor in the calling
1547 A34D              * bank we must clean up the stack.
1548 A34D              * This routine pulls the following info from the stack.
1549 A34D              *      # of bytes          Type of information
1550 A34D              *         2                 RTS data from bank FF
1551 A34D              *         1                 State register data
1552 A34D              *         3                 RTL data for return to calling bank
1553 A34D              *         1                 Speed data
1554 A34D              *         1                 'A' data
1555 A34D              *         2                 RTS data from calling bank
1556 A34D
1557 A34D              MONZ2RTN EQU   *
1558 A34D A2 0A                 LDX   #$0A                     ;10 bytes to remove
1559 A34F              @1       EQU   *
1560 A34F 68                    PLA                            ;Remove 1 byte from stack
1561 A350 CA                    DEX                            ;Decrement counter
1562 A351 D0 FC                 BNE   @1                       ;Loop til done
1563 A353 4C DB A9              JMP   MONZ2FF                  ;Restart monitor command line function
1564 A356
1565 A356
1566 A356              GOODCMD  EQU   *
1567 A356 E0 05                 CPX   #$05                     ;0-4 for 2 byte data changes
1568 A358 90 35                 BCC   @3                       ;
1569 A35A E0 10                 CPX   #$10                     ;Is it set video screen data ?
1570 A35C F0 0A                 BEQ   @0                       ;BRA if yes
1571 A35E E0 11                 CPX   #$11                     ;5-$0f for 1 byte data changes
1572 A360 B0 0D                 BCS   @1                       ;
1573 A362 8A                    TXA                            ;Create correct offset for indexing
1574 A363 69 05                 ADC   #$05                     ;Add 5 bytes used by 2 byte commands
1575 A365 AA                    TAX                            ;Index now fixed
1576 A366 80 2C                 BRA   @4                       ;Exit via 2 byte command routines
1577 A368              @0       EQU   *
1578 A368 A5 3E                 LDA   A2L                      ;Get the data to write to
1579 A36A 8F BB 01 E1           STA   >SCRNSTAT                ;Store it
1580 A36E 60                    RTS                            ;
1581 A36F
1582 A36F              @1       EQU   *
1583 A36F D0 03                 BNE   @2                       ;
1584 A371 4C AA A8              JMP   TCMD                     ;=$0F then time command
1585 A374
1586 A374              @2       EQU   *
1587 A374
1588 A374              *  >$0F then assume hextodec command
1589 A374 A9 08                 LDA   #DECMSG                  ;'Decimal-> ' message
1590 A376 20 80 C0              JSR   PRINTMSG                 ;
1591 A379
1592 A379 B8                    CLV                            ;Clear 'v' to print unsigned
1593 A37A 20 BB A3              JSR   HEXTODEC7                ;Print result
1594 A37D 20 91 AC              JSR   PR1BLNKFF                ;Print 1 blank spaces
1595 A380 A9 FB                 LDA   #'{'                     ;Print bracket for signed result
1596 A382 20 D1 A9              JSR   COUTFF                   ;
1597 A385
1598 A385 E2 40                 SEP   #$40                     ;Set 'v' to print '+'
1599 A387 20 BB A3              JSR   HEXTODEC7                ;Print result
1600 A38A 20 08 AE              JSR   RELADR2                  ;Print '}'
1601 A38D 80 BB                 BRA   DECTOHEX6                ;Next line+space then back to caller
1602 A38F
1603 A38F
1604 A38F              @3       EQU   *
1605 A38F 8A                    TXA                            ;X * 2 for indexing
1606 A390 0A                    ASL   A                        ;
1607 A391 AA                    TAX                            ;
1608 A392 C2 20                 REP   #$20                     ;16 bit mode a must
1609 A394              @4       EQU   *
1610 A394 A5 3E                 LDA   A2L                      ;Data to write is here
1611 A396 E0 0F                 CPX   #$0A+5                   ;'L' command offset
1612 A398 90 06                 BCC   @5                       ;<$0A+5 then not 'L','m','x','e'
1613 A39A E0 14                 CPX   #$0F+5                   ;
1614 A39C F0 02                 BEQ   @5                       ;= to 'F' cmd then save whole byte
1615 A39E 29 01                 AND   #$01                     ;
1616 A3A0              @5       EQU   *
1617 A3A0 9F 20 01 E1           STA   >AVAL,X                  ;Data goes here
1618 A3A4 E2 30                 SEP   #$30                     ;8 bit mode is normal monitor mode
1619 A3A6 A3 07                 LDA   7,S                      ;Get current user speed value
1620 A3A8 29 7F                 AND   #$7F                     ;Strip off hi bit
1621 A3AA 48                    PHA                            ;Save on stack
1622 A3AB AF 2E 01 E1           LDA   >QVAL                    ;
1623 A3AF 29 80                 AND   #$80                     ;Hi bit only important one
1624 A3B1 8F 38 01 E1           STA   >SYSTEMSPD               ;Set system speed mask
1625 A3B5 03 01                 ORA   1,S                      ;Create new speed byte
1626 A3B7 FA                    PLX                            ;Clean up stack
1627 A3B8 83 07                 STA   7,S                      ;Save new speed byte
1628 A3BA 60                    RTS                            ;Back to caller
1629 A3BB
1630 A3BB
1631 A3BB              HEXTODEC7 EQU   *
1632 A3BB 08                    PHP                            ;Preserve 'v'/'m/'x' status
1633 A3BC C2 30                 REP   #$30                     ;16 bit land required for call
1634 A3BE AF 40 01 E1           LDA   >EXTENDBNK               ;High word to convert
1635 A3C2 48                    PHA                            ;
1636 A3C3 A5 3E                 LDA   A2L                      ;Low word to convert
1637 A3C5 48                    PHA                            ;
1638 A3C6 F4 00 00              PEA   $0000                    ;High word of pointer to buffer
1639 A3C9 F4 00 02              PEA   IN                       ;Low word of pointer to buffer
1640 A3CC F4 10 00              PEA   $0010                    ;Size of buffer
1641 A3CF                       LONGA ON
1642 A3CF A9 01 00              LDA   #$0001                   ;<>0 if signed value requested
1643 A3D2                       LONGA OFF
1644 A3D2 70 01                 BVS   @1                       ;'v'=1 then print signed value
1645 A3D4 3A                    DEC   A                        ;=0 for unsigned result requested
1646 A3D5              @1       EQU   *
1647 A3D5 48                    PHA                            ;Req data type (signed/unsigned) to stack
1648 A3D6                       LONGI ON
1649 A3D6 A2 0B 27              LDX   #LONG2DEC*256+IMTN       ;Function number*256+tool number
1650 A3D9                       LONGI OFF
1651 A3D9 22 00 00 E1           JSL   >DISPATCH1               ;Call tool locator
1652 A3DD 28                    PLP                            ;Recall 'v'/'m'/'x' status
1653 A3DE
1654 A3DE A2 FF                 LDX   #$FF                     ;Start index at 0-1
1655 A3E0              @8       EQU   *
1656 A3E0 E8                    INX                            ;
1657 A3E1 E0 10                 CPX   #$10                     ;Stop at $10 always
1658 A3E3 B0 23                 BCS   @9                       ;
1659 A3E5 BD 00 02              LDA   IN,X                     ;Ignore spaces
1660 A3E8 C9 20                 CMP   #$20                     ;
1661 A3EA F0 F4                 BEQ   @8                       ;Loop til no spaces
1662 A3EC 50 0E                 BVC   @8_2                     ;'v'=0 then no signs
1663 A3EE C9 2D                 CMP   #$2D                     ;If not '-' then output '+'
1664 A3F0 F0 0A                 BEQ   @8_2                     ;
1665 A3F2 A9 AB                 LDA   #'+'                     ;Plus indicator
1666 A3F4 DA                    PHX                            ;Preserve 'X'
1667 A3F5 20 D1 A9              JSR   COUTFF                   ;
1668 A3F8 FA                    PLX                            ;Restore 'X'
1669 A3F9              @8_1     EQU   *
1670 A3F9 BD 00 02              LDA   IN,X                     ;Recall character to print
1671 A3FC              @8_2     EQU   *
1672 A3FC 09 80                 ORA   #$80                     ;Need high bit on to print
1673 A3FE DA                    PHX                            ;Preserve 'X'
1674 A3FF 20 D1 A9              JSR   COUTFF                   ;
1675 A402 FA                    PLX                            ;Recall 'X'
1676 A403 E8                    INX                            ;
1677 A404 E0 10                 CPX   #$10                     ;Stop at $10 always
1678 A406 90 F1                 BCC   @8_1                     ;Loop if not done yet
1679 A408              @9       EQU   *
1680 A408 60                    RTS                            ;Back to caller
1681 A409
1682 A409
1683 A409
1684 A409
1685 A409                       TITLE 'Misc Monitor Bank FF Rtnes1'
1686 A409
1687 A409              ******************************************************
1688 A409              *                                                    *
1689 A409              *        Miscellaneous Monitor Bank FF Routines1     *
1690 A409              *                                                    *
1691 A409              *                    by                              *
1692 A409              *               Fern Bachman     1985-1987           *
1693 A409              *               Joe Bo           1987-1989           *
1694 A409              *                                                    *
1695 A409              *       Copyright Apple Computer, Inc. 1985-1989     *
1696 A409              *                All Rights Reserved.                *
1697 A409              *                                                    *
1698 A409              ******************************************************
1699 A409
1700 A409              DECDISASM EQU   *                       ;Dec PCL/PCH-disassemble inst-inc PCL/PCH
1701 A409 AD FB 04              LDA   MODE                     ;'-' if PASCAL '+' if BASIC
1702 A40C 10 2F                 BPL   @2                       ;+ then no changing at all
1703 A40E C9 FF                 CMP   #$FF                     ;$FF=vanilla Apple// mode
1704 A410 F0 2B                 BEQ   @2                       ;Do nothing in this mode
1705 A412 2C 1F C0              BIT   RD80VID                  ;In 80 (-) columns or 40 (+) columns?
1706 A415 10 23                 BPL   @1                       ;
1707 A417
1708 A417 C2 30                 REP   #$30                     ;Save the Pascal screen
1709 A419                       LONGI ON
1710 A419 A2 05 09              LDX   #SVESCRNFN*256+DSKTN     ;'X'=function #*256+tool number
1711 A41C 22 00 00 E1           JSL   >DISPATCH1               ;Do the call
1712 A420 E2 30                 SEP   #$30                     ;Back to normal monitor mode
1713 A422                       LONGI OFF
1714 A422
1715 A422 A9 8D                 LDA   #$8D                     ;
1716 A424 20 E9 A9              JSR   C300FF                   ;Enable BASIC 80 columns
1717 A427
1718 A427 20 F9 81              JSR   SAVESHOLES               ;Save slot 0/3 screen holes
1719 A42A C2 30                 REP   #$30                     ;Restore the Pascal screen
1720 A42C                       LONGI ON
1721 A42C A2 05 0A              LDX   #RSTSCRNFN*256+DSKTN     ;'X'=function #*256+tool number
1722 A42F 22 00 00 E1           JSL   >DISPATCH1               ;Do the call
1723 A433 E2 30                 SEP   #$30                     ;Back to normal monitor mode
1724 A435                       LONGI OFF
1725 A435 20 FC 81              JSR   RSTRSHOLES               ;Restore slot 0/3 screen holes
1726 A438
1727 A438 80 03                 BRA   @2                       ;
1728 A43A
1729 A43A              @1       EQU   *                        ;Enable BASIC 40 columns
1730 A43A 20 EB CC              JSR   X_NAK2                   ;Set up 40 columns screen / set I/O hooks
1731 A43D
1732 A43D              @2       EQU   *
1733 A43D C2 30                 REP   #$30                     ;Off to 16 bit land
1734 A43F AF 16 01 E1           LDA   >irq_PC                  ;Interrupt program counter
1735 A443 48                    PHA                            ;
1736 A444 3A                    DEC   A                        ;Offset program cntr by 2 after saving it
1737 A445 3A                    DEC   A                        ;
1738 A446 85 3A                 STA   PCL                      ;Save for disassembly
1739 A448 E2 30                 SEP   #$30                     ;Back to 8 bit land
1740 A44A 8B                    PHB                            ;Save data bank register
1741 A44B 20 82 F8              JSR   DBTOE1                   ;Change data bank register to E1
1742 A44E A2 0B                 LDX   #IRQLEN-1                ;# of bytes to move -1
1743 A450              @3       EQU   *
1744 A450 BD 08 01              LDA   |irq_A,X                 ;Interrupt data
1745 A453 9D 20 01              STA   |AVAL,X                  ;Register data buffer
1746 A456 CA                    DEX                            ;
1747 A457 10 F7                 BPL   @3                       ;Loop til done
1748 A459 8E 8F 01              STX   |ORGMEMORY               ;<>0 so BRK/COP mem conf used in monitor
1749 A45C AD 18 01              LDA   |irq_state               ;Move state register
1750 A45F 8D 2D 01              STA   |MVAL                    ; to print register buffer.
1751 A462 29 04                 AND   #$04                     ;Get language card bank for LVAL
1752 A464 4A                    LSR   A                        ;Shift bit 2 to bit 0
1753 A465 4A                    LSR   A                        ;
1754 A466 8D 2F 01              STA   |LVAL                    ;Save in print buffer
1755 A469 AD 1A 01              LDA   |irq_shadow+1            ;Get interrupt CYAREG
1756 A46C 29 80                 AND   #$80                     ;Speed bit is high bit
1757 A46E 48                    PHA                            ;
1758 A46F AD 19 01              LDA   |irq_shadow              ;
1759 A472 03 01                 ORA   1,S                      ;Combine with speed bit for QVAL
1760 A474 8D 2E 01              STA   |QVAL                    ;Save for later
1761 A477 68                    PLA                            ;Clean up stack
1762 A478 AD 15 01              LDA   |irq_K                   ;Get program bank
1763 A47B 8D 2C 01              STA   |KVAL                    ;Save in print buffer
1764 A47E 8D 3E 01              STA   |BANKS                   ; and make disassembly bank.
1765 A481 AD 2A 01              LDA   |PVAL                    ;Fix 'm'/'x' print registers
1766 A484 29 30                 AND   #$30                     ;
1767 A486 4A                    LSR   A                        ;Shift 'x' into 'c' and 'm' into bit 0
1768 A487 20 7B F8              JSR   SCRN4                    ;Shifts right 4 times
1769 A48A 8D 30 01              STA   |MPVAL                   ;Save new 'm' value
1770 A48D A9 00                 LDA   #$00                     ;
1771 A48F 2A                    ROL   A                        ;
1772 A490 8D 31 01              STA   |XPVAL                   ;
1773 A493 AD 14 01              LDA   |irq_e                   ;Move 'e' bit to print buffer
1774 A496 29 01                 AND   #$01                     ;'e' is low bit
1775 A498 8D 32 01              STA   |EPVAL                   ;
1776 A49B 6A                    ROR   A                        ;e to c
1777 A49C C2 30                 REP   #$30
1778 A49E AD 26 01              LDA   |SVAL                    ;Get real brk irq_stack pointer
1779 A4A1 1A                    INC   A                        ;Adjust back to usr stack pointer
1780 A4A2 1A                    INC   A
1781 A4A3 1A                    INC   A
1782 A4A4 B0 01                 BCS   @0                       ;BRA if emulation mode
1783 A4A6 1A                    INC   A                        ; else adjust one more
1784 A4A7              @0       EQU   *
1785 A4A7 8D 26 01              STA   |SVAL                    ;Store back usr's sp before brk
1786 A4AA E2 30                 SEP   #$30
1787 A4AC
1788 A4AC              * When a 'brk' is hit, the screen i/o switch is saved but not the 
1789 A4AC              * screen image itself.  Cntl_T is now re-defined as flipping the
1790 A4AC              * textpage1 and the screen display when brk occurred, it is toggled
1791 A4AC              * by the 'Flipscrn' flag.
1792 A4AC              * 'Scrnstat' is used to save the screen i/o switches states:
1793 A4AC              * bit7 = super hi res
1794 A4AC              * bit6 = text not graphic
1795 A4AC              * bit5 = mixed mode
1796 A4AC              * bit4 = hi res
1797 A4AC              * bit3 = textpage2/textpage1
1798 A4AC              * bit2 = x
1799 A4AC              * bit1 = x               
1800 A4AC              * bit0 = x               
1801 A4AC              *
1802 A4AC              * The 'brk' screen states are resumed if the 'Resume' command, 'r'
1803 A4AC              * is executed to continue the program
1804 A4AC
1805 A4AC 9C A8 01              STZ   |FLIPSCRN                ;Set toggle bit to 0, cntl_t
1806 A4AF 9C BB 01              STZ   |SCRNSTAT                ;Set to zero first
1807 A4B2 A9 00                 LDA   #$00                     ;Assume zero first
1808 A4B4 AE 1C C0              LDX   |RDPAGE2                 ;Get text page bit
1809 A4B7 10 02                 BPL   @6                       ;bra for text page 1
1810 A4B9 09 08                 ORA   #$08                     ;else set the bit for text page 2
1811 A4BB AE 1D C0     @6       LDX   |RDHIRES                 ;Get hires/lores bit
1812 A4BE 10 02                 BPL   @7                       ;bra for lores
1813 A4C0 09 10                 ORA   #$10                     ;set hires bit   
1814 A4C2 AE 1B C0     @7       LDX   |RDMIX                   ;Get mixed mode bit
1815 A4C5 10 02                 BPL   @8                       ;bra if not mixed mode
1816 A4C7 09 20                 ORA   #$20                     ;else set mixed mode on
1817 A4C9 AE 1A C0     @8       LDX   |RDTEXT                  ;Get text/graphic bit
1818 A4CC 10 02                 BPL   @9                       ;bra for graphic mode
1819 A4CE 09 40                 ORA   #$40                     ;else set text mode
1820 A4D0 AE 29 C0     @9       LDX   |NEWVIDEO                ;Get super hi-res
1821 A4D3 10 02                 BPL   @11                      ;bra if off
1822 A4D5 09 80                 ORA   #$80                     ;else set bit on
1823 A4D7              @11      EQU   *
1824 A4D7 8D BB 01              STA   |SCRNSTAT                ;Store the results here
1825 A4DA
1826 A4DA 20 00 A8              JSR   SETPAG1                  ;Force to text page 1
1827 A4DD
1828 A4DD AB                    PLB                            ;Get back data bank
1829 A4DE 20 2C AD              JSR   DISASEM
1830 A4E1 A9 00                 LDA   #$00                     ;Reset MEMORYMSK for regular disassemblies
1831 A4E3 8F 8F 01 E1           STA   >ORGMEMORY               ;=0 so monitor use special mem config
1832 A4E7 68                    PLA                            ;Restore PCL/PCH
1833 A4E8 85 3A                 STA   PCL                      ;
1834 A4EA 68                    PLA                            ;
1835 A4EB 85 3B                 STA   PCH                      ;Fall to register display routine
1836 A4ED
1837 A4ED
1838 A4ED              REGDSP2  EQU   *
1839 A4ED 20 CF A9              JSR   CROUTFF                  ;Next line please
1840 A4F0 A2 00                 LDX   #$00                     ;Start with 1st variable
1841 A4F2              @3       EQU   *
1842 A4F2 DA                    PHX                            ;MUST save 'X' index
1843 A4F3 20 91 AC              JSR   PR1BLNKFF                ;Print one space
1844 A4F6 BF EA C0 FF           LDA   >NEWCMDSTBL,X            ;Get variable name
1845 A4FA 20 D1 A9              JSR   COUTFF                   ;Show user
1846 A4FD A9 BD                 LDA   #'='                     ;Show required '=' sign
1847 A4FF 20 D1 A9              JSR   COUTFF                   ;
1848 A502 FA                    PLX                            ;Recall index
1849 A503 DA                    PHX                            ;MUST save 'X' index
1850 A504 E0 0A                 CPX   #$0A                     ;1 nybble to show?
1851 A506 B0 22                 BCS   @7                       ;'c' = 1 then yes
1852 A508 E0 05                 CPX   #$05                     ;2 byte/1byte to show
1853 A50A B0 10                 BCS   @5                       ;
1854 A50C 8A                    TXA                            ;Real index = actual index * 2
1855 A50D 0A                    ASL   A                        ;
1856 A50E AA                    TAX                            ;
1857 A50F BF 21 01 E1           LDA   >AVAL+1,X                ;Hi byte to show
1858 A513 20 A3 A9              JSR   PRBYTEFF                 ;Show to user
1859 A516 BF 20 01 E1           LDA   >AVAL,X                  ;Byte to show
1860 A51A 80 04                 BRA   @5_2                     ;
1861 A51C              @5       EQU   *
1862 A51C BF 25 01 E1           LDA   >AVAL+5,X                ;Byte to show
1863 A520              @5_2     EQU   *
1864 A520 20 A3 A9              JSR   PRBYTEFF                 ;Show to user
1865 A523              @6       EQU   *
1866 A523 FA                    PLX                            ;Increment and test for done
1867 A524 E8                    INX                            ;
1868 A525 E0 0E                 CPX   #$0E                     ;If incremented to $0E then done
1869 A527 90 C9                 BCC   @3                       ;
1870 A529 60                    RTS                            ;Back to caller if here
1871 A52A
1872 A52A              @7       EQU   *
1873 A52A BF 25 01 E1           LDA   >AVAL+5,X                ;Get byte/nybble to show
1874 A52E 20 99 A9              JSR   PRHEXFF                  ;Print 1 digit
1875 A531 80 F0                 BRA   @6                       ;Exit to main loop
1876 A533                       EJECT 
1877 A533              * SYSDEATH is called by the miscellaneous tool
1878 A533              * locator in native mode with 16 bit 'm'/'x'
1879 A533              * and the following information on the stack.
1880 A533              *
1881 A533              *    9,S  -  Error hi byte
1882 A533              *    8,S  -        lo byte
1883 A533              *    7,S  -  Null byte of message address
1884 A533              *    6,S  -  Bank byte of message address
1885 A533              *    5,S  -  Hi byte of message address
1886 A533              *    4,S  -  Lo byte of message address
1887 A533              *    3,2,1,S -  Unused return address
1888 A533              *
1889 A533              *    'c' = 0 = Use user defined message
1890 A533              *        = 1 = Use default message
1891 A533              *
1892 A533              *    User defined system death message is in
1893 A533              *    is defined as follows.
1894 A533              *
1895 A533              *    1st byte = length of message
1896 A533              *    2nd...xth byte = hi bit off ASCII message
1897 A533              *
1898 A533              *    After the messages (either one) is displayed
1899 A533              *    the system death error number is printed and
1900 A533              *    the moving apple is displayed on the screen.
1901 A533
1902 A533                                                      ; SEG $FF
1903 A533              SYSDEATH EQU   *
1904 A533                                                      ; SEG $00
1905 A533 78                    SEI                            ;No interrupts please
1906 A534                       LONGA ON
1907 A534 A9 00 00              LDA   #$0000                   ;Set direct register
1908 A537 8F FF 00 E1           STA   >BUSYFLAG                ;Clear out system busy flag
1909 A53B                       LONGA OFF
1910 A53B 5B                    TCD                            ;
1911 A53C 48                    PHA                            ;Change DBR to 00
1912 A53D AB                    PLB                            ;
1913 A53E AB                    PLB                            ;
1914 A53F A3 04                 LDA   4,S                      ;Move message address to zero page
1915 A541 85 FB                 STA   $FB                      ;Hard code
1916 A543 A3 06                 LDA   6,S                      ;
1917 A545 85 FD                 STA   $FD                      ;
1918 A547 A3 08                 LDA   8,S                      ;Get error code in 16 bit 'A'
1919 A549                       LONGI ON
1920 A549 A2 7F 01              LDX   #$17F                    ;Force stack
1921 A54C                       LONGI OFF
1922 A54C 9A                    TXS                            ;Switch stack to safe place
1923 A54D 48                    PHA                            ;Save 16 byte error number on stack
1924 A54E E2 30                 SEP   #$30                     ;Go to 8 bit land
1925 A550 08                    PHP                            ;Save 'c' status for correct message
1926 A551 A9 80                 LDA   #$80                     ;Set system speed mask
1927 A553 8F 38 01 E1           STA   >SYSTEMSPD               ;
1928 A557 8D 07 C0              STA   SETINTCXROM              ;Enable internal CXROM
1929 A55A A9 08                 LDA   #$08                     ;Enable ROM
1930 A55C 0C 68 C0              TSB   STATEREG                 ;
1931 A55F              ;JSR GOTXT1 ;Go to text page 1
1932 A55F 20 00 A8              JSR   SETPAG1
1933 A562 20 EB CC              JSR   X_NAK2                   ;Set up 40 columns screen / set I/O hooks
1934 A565 20 EE A9              JSR   HOMEFF                   ;Clear the 40 column screen
1935 A568 28                    PLP                            ;Recall 'c' status
1936 A569 B0 19                 BCS   NODISK3                  ;'c'=1 then use monitor's sys death msg
1937 A56B A7 FB                 LDA   [$FB]                    ;Set ending index
1938 A56D 1A                    INC   A                        ;Add 1 for correct testing
1939 A56E 85 FF                 STA   $FF                      ;
1940 A570 A0 01                 LDY   #$01                     ;Start with first character to show
1941 A572              @1       EQU   *
1942 A572 B7 FB                 LDA   [$FB],Y                  ;Get a byte
1943 A574 09 80                 ORA   #$80                     ;Set hi byte before printing
1944 A576 5A                    PHY                            ;Save pointer
1945 A577 20 D1 A9              JSR   COUTFF                   ;Print the byte
1946 A57A 7A                    PLY                            ;Recall the pointer
1947 A57B C8                    INY                            ;Inc to next byte
1948 A57C C4 FF                 CPY   $FF                      ;Test if done
1949 A57E 90 F2                 BCC   @1                       ;Loop til done
1950 A580
1951 A580 58                    CLI                            ;Re-enable ints so dsk acc are available
1952 A581
1953 A581 B0 1F                 BCS   NODISK7                  ;Fall into regular loop
1954 A583
1955 A583
1956 A583              NODISK2  EQU   *
1957 A583 18                    CLC                            ;'c'=0 if 'Check startup device!' error
1958 A584              NODISK3  EQU   *
1959 A584 08                    PHP                            ;Save 'c' status
1960 A585 20 F3 A9              JSR   SETVIDKBDFF              ;Set 40 column video and keyboard
1961 A588 20 EE A9              JSR   HOMEFF                   ;Clear the screen
1962 A58B A2 00                 LDX   #$00                     ;
1963 A58D A0 05                 LDY   #$05                     ;Vertical tab
1964 A58F 20 E0 A9              JSR   SETVTAB                  ;Move to position
1965 A592 28                    PLP                            ;Recall 'c' status
1966 A593 08                    PHP                            ; and resave it for later
1967 A594 B0 04                 BCS   @4                       ;'c'=1 if system death
1968 A596 A9 03                 LDA   #CHKDEVMSG               ;'Check startup device!' message
1969 A598 80 02                 BRA   @6                       ;
1970 A59A              @4       EQU   *
1971 A59A A9 0C                 LDA   #SYSDMSG                 ;'Fatal system error -> ' message
1972 A59C              @6       EQU   *
1973 A59C 20 80 C0              JSR   PRINTMSG                 ;
1974 A59F 28                    PLP                            ;Recall 'c' status
1975 A5A0 90 05                 BCC   NODISK9                  ;'c'=0 then no more to print
1976 A5A2              NODISK7  EQU   *
1977 A5A2 FA                    PLX                            ;Low byte of error number to 'X'
1978 A5A3 7A                    PLY                            ;High byte of error number to 'Y'
1979 A5A4 20 9E A9              JSR   PRNTYXFF                 ;
1980 A5A7              NODISK9  EQU   *
1981 A5A7 8D 0F C0              STA   SETALTCHAR               ;Enable alternate character set
1982 A5AA 20 51 9A              JSR   NEWBELL1                 ;Ring them chimes
1983 A5AD
1984 A5AD A9 06                 LDA   #$6                      ;Do message on this line
1985 A5AF 85 22                 STA   WNDTOP                   ;
1986 A5B1
1987 A5B1 A0 00                 LDY   #$00                     ;Starting offset
1988 A5B3              @22      EQU   *
1989 A5B3 F0 05                 BEQ   @23                      ;
1990 A5B5 A9 DF                 LDA   #$DF                     ;Alternate character
1991 A5B7 99 A8 05              STA   $5A9-1,Y                 ;
1992 A5BA              @23      EQU   *
1993 A5BA A9 41                 LDA   #$41                     ;Open Apple character
1994 A5BC 99 A9 05              STA   $5A9,Y                   ;Put up new Apple
1995 A5BF 20 DA A5              JSR   @33                      ;
1996 A5C2 C8                    INY                            ;
1997 A5C3 C0 26                 CPY   #$26                     ;26 last index to use
1998 A5C5 90 EC                 BCC   @22                      ;
1999 A5C7 88                    DEY                            ;
2000 A5C8              @24      EQU   *
2001 A5C8 A9 4C                 LDA   #$4C                     ;Alternate character
2002 A5CA 99 A9 05              STA   $5A9,Y                   ;
2003 A5CD A9 40                 LDA   #$40                     ;Closed Apple character
2004 A5CF 99 A8 05              STA   $5A9-1,Y                 ;Put up new Apple
2005 A5D2 20 DA A5              JSR   @33                      ;
2006 A5D5 88                    DEY                            ;
2007 A5D6 D0 F0                 BNE   @24                      ;
2008 A5D8 80 D9                 BRA   @22                      ;
2009 A5DA
2010 A5DA
2011 A5DA              @33      EQU   *
2012 A5DA AD 00 C0              LDA   KBD                      ;If ctrl pressed do test
2013 A5DD 8D 10 C0              STA   KBDSTRB                  ;
2014 A5E0 C9 8E                 CMP   #$8E                     ;Control-'N'
2015 A5E2 D0 0D                 BNE   @34                      ;
2016 A5E4 AD 62 C0              LDA   BUTN1                    ;If closed apple down test open apple
2017 A5E7 10 08                 BPL   @34                      ;
2018 A5E9 AD 61 C0              LDA   BUTN0                    ;If open apple down too
2019 A5EC 10 03                 BPL   @34                      ;
2020 A5EE 20 FC A5              JSR   @40                      ;Do tests
2021 A5F1              @34      EQU   *
2022 A5F1 AD 19 C0              LDA   RDVBLBAR                 ;Wait if in VBL
2023 A5F4 10 FB                 BPL   @34                      ;
2024 A5F6              @32      EQU   *
2025 A5F6 AD 19 C0              LDA   RDVBLBAR                 ;Wait if not in VBL
2026 A5F9 30 FB                 BMI   @32                      ;
2027 A5FB 60                    RTS                            ;
2028 A5FC
2029 A5FC
2030 A5FC              @40      EQU   *                        ;Do tests
2031 A5FC 5A                    PHY                            ;MUST preserve pointer around call
2032 A5FD 20 EE A9              JSR   HOMEFF                   ;Clear the specific screen first
2033 A600 A9 06                 LDA   #6                       ;Position for messages
2034 A602 85 25                 STA   CV                       ;
2035 A604 64 24                 STZ   CH                       ;
2036 A606 20 E4 A9              JSR   VTABFF                   ;
2037 A609 22 18 00 FE           JSL   >$FE0018                 ;{MSA 4/20/89} A touch of audio makes it
2038 A60D A9 F3                 LDA   #N1                      ;Pointer number
2039 A60F 20 24 A6              JSR   @60                      ;Make a delay
2040 A612 A9 0F                 LDA   #15                      ;Position the message
2041 A614 85 25                 STA   CV                       ;
2042 A616 A9 02                 LDA   #2
2043 A618 85 24                 STA   CH                       ;
2044 A61A 20 E4 A9              JSR   VTABFF                   ;
2045 A61D A9 F4                 LDA   #N2                      ;Pointer number
2046 A61F 20 24 A6              JSR   @60                      ;Print / delay /clear
2047 A622 7A                    PLY                            ;Restore y
2048 A623 60                    RTS                            ;
2049 A624
2050 A624              @60      EQU   *
2051 A624 22 98 00 E1           JSL   >TOPRINTMSG8             ;Print message
2052 A628 A9 80                 LDA   #$80                     ;Slow wait
2053 A62A 1C 36 C0              TRB   CYAREG                   ;
2054 A62D A2 10                 LDX   #$10                     ;Wait and then clear screen
2055 A62F              @50      EQU   *
2056 A62F A9 FF                 LDA   #$FF                     ;Wait and then clear screen
2057 A631 20 A8 FC              JSR   WAIT                     ;
2058 A634 CA                    DEX                            ;Loop til done
2059 A635 D0 F8                 BNE   @50                      ;
2060 A637 A9 80                 LDA   #$80                     ;Speed back up
2061 A639 0C 36 C0              TSB   CYAREG                   ;
2062 A63C 20 EE A9              JSR   HOMEFF                   ;Clear screen and continue
2063 A63F 60                    RTS                            ;Back to caller
2064 A640
2065 A640
2066 A640              * ADDSUB add (if 'c'=0) or subtracts (if 'c'=1)
2067 A640              *        up to 32 bit numbers the user entered.
2068 A640
2069 A640                       LONGA ON
2070 A640              DOADD    EQU   *
2071 A640 18                    CLC                            ;'c'=0 to add
2072 A641              ADDSUB   EQU   *
2073 A641 C2 30                 REP   #$30                     ;16 bit land required
2074 A643 AF 40 01 E1           LDA   >EXTENDBNK               ;Get high word of user's second number
2075 A647 90 03                 BCC   @2                       ;'c'=0 then do not change
2076 A649 49 FF FF              EOR   #$FFFF                   ;Make 2's complement for subtract
2077 A64C              @2       EQU   *
2078 A64C 48                    PHA                            ;Save on stack for later
2079 A64D A5 3E                 LDA   A2L                      ;Recall low word of 1st number entered
2080 A64F 90 03                 BCC   @4                       ;'c'=0 then do not change
2081 A651 49 FF FF              EOR   #$FFFF                   ;Make 2's complement for subtract
2082 A654              @4       EQU   *
2083 A654 65 3C                 ADC   A1L                      ;Add low word of 2nd number entered
2084 A656 85 3E                 STA   A2L                      ;Save in case someone looks here
2085 A658 AF 46 01 E1           LDA   >EXTENDBNKS              ;Recall 1st number's high word
2086 A65C 63 01                 ADC   1,S                      ; and add 2nd numbers high word
2087 A65E 83 01                 STA   1,S                      ;Save result on stack
2088 A660
2089 A660 E2 30                 SEP   #$30                     ;Back to monitor mode
2090 A662                       LONGA OFF
2091 A662 20 74 A6              JSR   PRINTDASHDOL             ;Print '-> $'
2092 A665 FA                    PLX                            ;Recall low byte of high word to print
2093 A666 68                    PLA                            ;Recall high byte of high word to print
2094 A667 20 9F A9              JSR   PRNTAXFF                 ;Print word
2095 A66A A5 3F                 LDA   A2H                      ;Recall high byte of low word to print
2096 A66C A6 3E                 LDX   A2L                      ;Recall low byte of low word to print
2097 A66E 20 9F A9              JSR   PRNTAXFF                 ;Print word and exit
2098 A671              ADDSUB9  EQU   *
2099 A671 4C 52 AC              JMP   LIST3                    ;Carriage return followed by space
2100 A674
2101 A674              PRINTDASHDOL EQU   *
2102 A674 A9 0A                 LDA   #ARWDASHDOL              ;Print '-> $'
2103 A676 4C 80 C0              JMP   PRINTMSG                 ;
2104 A679
2105 A679
2106 A679              MATH     EQU   *
2107 A679 C9 AD                 CMP   #'-'                     ;Test for subtraction
2108 A67B F0 C4                 BEQ   ADDSUB                   ;'c'=1 to subtract
2109 A67D C9 AB                 CMP   #'+'                     ;Test for addition
2110 A67F F0 BF                 BEQ   DOADD                    ;
2111 A681 C9 AA                 CMP   #'*'                     ;Test for multiplication
2112 A683 F0 01                 BEQ   @1                       ;'c'=1 for multiplication
2113 A685 18                    CLC                            ;'c'=0 for division
2114 A686
2115 A686
2116 A686              * @1 multiplies or divides 32 bit numbers
2117 A686              *         depending on the setting of 'c'
2118 A686              *               'c'=0 if division
2119 A686              *               'c'=1 if multiplication
2120 A686
2121 A686              @1       EQU   *
2122 A686 08                    PHP                            ;Preserve entry 'c' status
2123 A687 A2 04                 LDX   #$04                     ;Push 8 bytes of room on stack
2124 A689 20 E6 A6              JSR   PUSH                     ; and switch to 16 bit mode.
2125 A68C AF 46 01 E1           LDA   >EXTENDBNKS              ;Push hi word of 1st number on stack
2126 A690 48                    PHA                            ;
2127 A691 A5 3C                 LDA   A1L                      ;Push lo word of 1st number on stack
2128 A693 48                    PHA                            ;
2129 A694 AF 40 01 E1           LDA   >EXTENDBNK               ;Push hi word of 2nd number on stack
2130 A698 48                    PHA                            ;
2131 A699 A5 3E                 LDA   A2L                      ;Push lo word of 2nd number on stack
2132 A69B 48                    PHA                            ;
2133 A69C                       LONGI ON
2134 A69C A2 0B 0C              LDX   #LONGMUL*256+IMTN        ;Function number*256+tool number
2135 A69F B0 03                 BCS   @12                      ;'c'=1 then doing multiplication
2136 A6A1 A2 0B 0D              LDX   #LONGDIV*256+IMTN        ;Function number*256+tool number
2137 A6A4                       LONGI OFF
2138 A6A4              @12      EQU   *
2139 A6A4 22 00 00 E1           JSL   >DISPATCH1               ;Off to tool locator
2140 A6A8
2141 A6A8 E2 30                 SEP   #$30                     ;Back to 16 bit world
2142 A6AA A2 00                 LDX   #$00                     ;Recall 8 bytes from stack
2143 A6AC              @13      EQU   *
2144 A6AC 68                    PLA                            ;Recall result from call
2145 A6AD 95 3C                 STA   A1L,X                    ;And save in zero page
2146 A6AF E8                    INX                            ;
2147 A6B0 E0 08                 CPX   #$08                     ;Stop when 'X'=8
2148 A6B2 D0 F8                 BNE   @13                      ;Loop til done
2149 A6B4
2150 A6B4 28                    PLP                            ;Recall entry 'c' status
2151 A6B5 08                    PHP                            ; and resave it.
2152 A6B6 B0 05                 BCS   @14                      ;Skip 'R'
2153 A6B8 A9 D2                 LDA   #'R'                     ;'R' for remainder
2154 A6BA 20 D1 A9              JSR   COUTFF                   ;
2155 A6BD              @14      EQU   *
2156 A6BD 20 74 A6              JSR   PRINTDASHDOL             ;Print '-> $' ASCII
2157 A6C0
2158 A6C0 A2 07                 LDX   #$07                     ;Print 8 bytes
2159 A6C2              @18      EQU   *
2160 A6C2 B5 3C                 LDA   A1L,X                    ;
2161 A6C4 DA                    PHX                            ;Preserve 'X'
2162 A6C5 20 A3 A9              JSR   PRBYTEFF                 ;Print byte
2163 A6C8 E0 04                 CPX   #$04                     ;Print a 'Q-> $' after 4 bytes
2164 A6CA D0 10                 BNE   @16                      ;
2165 A6CC A3 02                 LDA   2,S                      ;Recall multiplication/division indicator
2166 A6CE 6A                    ROR   A                        ;Shift saved carry bit into 'c'
2167 A6CF B0 0B                 BCS   @16                      ;Multiplication then continue normally
2168 A6D1 20 C8 A9              JSR   PRBLNKFF                 ;Print '   '
2169 A6D4 A9 D1                 LDA   #'Q'                     ;Print quotient indicator
2170 A6D6 20 D1 A9              JSR   COUTFF                   ;
2171 A6D9 20 74 A6              JSR   PRINTDASHDOL             ;Print '-> $' ASCII
2172 A6DC              @16      EQU   *
2173 A6DC FA                    PLX                            ;Recall 'X'
2174 A6DD CA                    DEX                            ;
2175 A6DE 10 E2                 BPL   @18                      ;Loop til done
2176 A6E0 28                    PLP                            ;Clean up stack
2177 A6E1 80 8E                 BRA   ADDSUB9                  ;Carriage return followed by space to end
2178 A6E3 60                    RTS   
2179 A6E4
2180 A6E4
2181 A6E4              PUSH6    EQU   *                        ;Push room for 6 bytes on stack
2182 A6E4 A2 03                 LDX   #$03                     ;Push 6 bytes on stack
2183 A6E6              PUSH     EQU   *                        ;Push room for 'X'*2 bytes on stack
2184 A6E6 C2 30                 REP   #$30                     ;16 bit land a must
2185 A6E8 68                    PLA                            ;Recall return address from stack
2186 A6E9              @1       EQU   *
2187 A6E9 F4 00 00              PEA   $0000                    ;Push 2 bytes of space on stack
2188 A6EC CA                    DEX                            ;
2189 A6ED D0 FA                 BNE   @1                       ;
2190 A6EF 48                    PHA                            ;Put RTS address back on stack
2191 A6F0 60                    RTS                            ;Back to caller in 16 bit mode
2192 A6F1                       EJECT 
2193 A6F1              *
2194 A6F1              * This code is called by the tool locator via
2195 A6F1              * vector $E1007C.  It will search for an expansion
2196 A6F1              * rom in bank $F8-$FF according to the following
2197 A6F1              * protocol.
2198 A6F1              *
2199 A6F1              * The bank $F8 expansion rom must have the following
2200 A6F1              * information located at the base of the rom.
2201 A6F1              *
2202 A6F1              * $F80000-F80007 ... An ASCII string 'ROMTOOLS'
2203 A6F1              * $F80008-F80009 ... Version Number
2204 A6F1              * $F8000A-F8001F ... Pad Area
2205 A6F1              * $F80020 .......... Entry Point
2206 A6F1              *
2207 A6F1              * The entry point is called in 16 bit native mode.
2208 A6F1              * (e=0, m=0, x=0) The entry point will execute
2209 A6F1              * code to install any rom based extensions to the
2210 A6F1              * tool set and return with an 'RTL' instruction
2211 A6F1              * with the carry flag cleared.  If the rom is found,
2212 A6F1              * the version number will be returned in the 16 bit
2213 A6F1              * C register after the 'RTL' is executed.
2214 A6F1              *
2215 A6F1              * Note that the string at $F80000 must have the
2216 A6F1              * msb set to a '1'.
2217 A6F1              *
2218 A6F1                       MSB   on
2219 A6F1                       LONGI ON
2220 A6F1                       LONGA ON
2221 A6F1
2222 A6F1                                                      ; SEG $ff
2223 A6F1              ROMTOOL  EQU   *
2224 A6F1                                                      ; SEG $00
2225 A6F1
2226 A6F1 A2 06 00              LDX   #$0006                   ; point at end of string
2227 A6F4              @1       EQU   *
2228 A6F4 BF 00 00 F8           LDA   >ExRomStr,x              ; get expansion rom data
2229 A6F8 DF 0D A7 FF           CMP   >string,x                ; and check against string
2230 A6FC D0 0D                 BNE   @2                       ; no rom if miscompare
2231 A6FE CA                    DEX   
2232 A6FF CA                    DEX   
2233 A700 10 F2                 BPL   @1
2234 A702 22 20 00 F8           JSL   >ExRomEntry              ; off to the expansion rom
2235 A706 AF 08 00 F8           LDA   >ExRomVer                ; return version in 'c' register
2236 A70A 6B                    RTL   
2237 A70B
2238 A70B              @2       EQU   *
2239 A70B 38                    SEC                            ; error if no rom
2240 A70C 6B                    RTL   
2241 A70D
2242 A70D                                                      ; SEG $FF
2243 A70D              STRING   EQU   *
2244 A70D                                                      ; SEG $00
2245 A70D D2 CF CD D4           DC B:'ROMTOOLS'
2246 A715
2247 A715
2248 A715                       LONGI OFF
2249 A715                       LONGA OFF
2250 A715
2251 A715
2252 A715
2253 A715
2254 A715                       TITLE 'Misc Monitor Bank FF Rtne2'
2255 A715
2256 A715              ******************************************************
2257 A715              *                                                    *
2258 A715              *        Miscellaneous Monitor Bank FF Routine2      *
2259 A715              *                                                    *
2260 A715              *                    by                              *
2261 A715              *               Fern Bachman     1985-1987           *
2262 A715              *               Joe Bo           1987-1989           *
2263 A715              *                                                    *
2264 A715              *       Copyright Apple Computer, Inc. 1985-1989     *
2265 A715              *                All Rights Reserved.                *
2266 A715              *                                                    *
2267 A715              ******************************************************
2268 A715
2269 A715
2270 A715              * RESUMEFF does and equivalent JMP absolute long
2271 A715              *          to the user specified routine with the
2272 A715              *          environment set up according to the
2273 A715              *          register/memory data stored in bank E1.
2274 A715              *
2275 A715              * X816FF  does an equivalent JSL to the subroutine
2276 A715              *         indicated by the user.  Using a JSL equivalent
2277 A715              *         means the subroutine can be in any bank.
2278 A715              *         X816FF assumes the user's routine ends in an
2279 A715              *         RTL which is used to return to the monitor.
2280 A715              *
2281 A715              * GO816FF does an equivalent JSR to the subroutine
2282 A715              *         indicated by the user.  Using a JSR equivalent
2283 A715              *         means that it can be used in the current
2284 A715              *         monitor bank only (normally bank 00). This
2285 A715              *         command assumes the user's routine ends in
2286 A715              *         an RTS which is used to return to the monitor.
2287 A715              *
2288 A715              *  Note: X816FF/GO816FF will automatically switch to native
2289 A715              *        mode if 'e'=0 execute the program and return
2290 A715              *        back to emulation mode and the monitor if
2291 A715              *        the native mode routine executes an RTS/RTL as
2292 A715              *        its last instruction.
2293 A715              *
2294 A715              * RTL/RTS information on stack for the 'X'/'G' command.
2295 A715              *       _____________
2296 A715              *      |             |
2297 A715              *      | Monitor Bnk |  <----- Only put on stack if 'X' command!!!!!!
2298 A715              *      |_____________|
2299 A715              *      |             |
2300 A715              *      |   <GORTL    |  <----- High byte of return address
2301 A715              *      |_____________|
2302 A715              *      |             |
2303 A715              *      |   >GORTL    |  <----- Low byte of return address
2304 A715              *      |_____________|
2305 A715              *
2306 A715              *
2307 A715              * RTI information on stack for either command ('X'/'G').
2308 A715              *       _____________
2309 A715              *      |             |
2310 A715              *      | Program Bnk |  <----- Only put on stack if native mode 'X'/'G'
2311 A715              *      |_____________|
2312 A715              *      |             |
2313 A715              *      |     PCH     |
2314 A715              *      |_____________|
2315 A715              *      |             |
2316 A715              *      |     PCL     |
2317 A715              *      |_____________|
2318 A715              *      |             |
2319 A715              *      |  'P' status |
2320 A715              *      |_____________|
2321 A715
2322 A715
2323 A715              RESUMEFF EQU   *                        ;Also entry point from step/trace 'G'
2324 A715 DA                    PHX                            ;Preserve 'x', needed in FIXE1PCLH
2325 A716 20 11 A8              JSR   BRKSCRN                  ;Restore the scrn when 'brk' occurred
2326 A719 FA                    PLX                            ;Restore x
2327 A71A 20 DA A7              JSR   FIXE1PCLH
2328 A71D 80 62                 BRA   GO816_4                  ;Continue in 'G'o code
2329 A71F
2330 A71F              X816FF   EQU   *
2331 A71F 18                    CLC                            ;'c'=0 if entered here
2332 A720 AF 3E 01 E1           LDA   >BANKS                   ;If <>0 and emulation beep and quit now
2333 A724 F0 13                 BEQ   GO816FF1_0               ;In bank 00 then ok
2334 A726 AF 32 01 E1           LDA   >EPVAL                   ;If <> bank 00 + emulation mode then beep
2335 A72A F0 0D                 BEQ   GO816FF1_0               ;
2336 A72C 4C 51 9A              JMP   NEWBELL1                 ;Beep and exit via bell routine
2337 A72F
2338 A72F              GO816FF  EQU   *
2339 A72F 38                    SEC                            ;'c'=1 if entered here
2340 A730 AF 3E 01 E1           LDA   >BANKS                   ;If <>0 then 'G'o not allowed
2341 A734 F0 03                 BEQ   GO816FF1_0               ;In bank 00 then ok
2342 A736 4C 51 9A              JMP   NEWBELL1                 ;Beep and exit via bell routine
2343 A739
2344 A739              GO816FF1_0 EQU   *
2345 A739 8B                    PHB                            ;Save original data bank register on stack
2346 A73A AD 68 C0              LDA   STATEREG                 ;Save state register
2347 A73D 48                    PHA                            ;
2348 A73E 20 DA A7              JSR   FIXE1PCLH                ;Move PCL/PCH to bank E1 in case alt zp
2349 A741 AE 35 C0              LDX   SHADOW                   ;Save SHADOW/CYAREG register
2350 A744 DA                    PHX                            ;
2351 A745 BA                    TSX                            ;Save stack pointer
2352 A746 8E 3C 01              STX   |GOS                     ;Save for later restoring
2353 A749 08                    PHP                            ;Save 'c'/'v' status, v from FIXE1PCLH
2354 A74A                       LONGA ON
2355 A74A C9 00 02              CMP   #$0200                   ;Not in regular stk area then leave alone
2356 A74D                       LONGA OFF
2357 A74D B0 0A                 BCS   GO816_0_4                ;'c'=1 then stack is not in regular stack
2358 A74F CD 3C 01              CMP   |GOS                     ;User stk ptr must be less than monitor's
2359 A752 70 05                 BVS   GO816_0_4                ;Using alternate stack then skip it
2360 A754 90 03                 BCC   GO816_0_4                ;< monitor's then all's OK for now
2361 A756 AD 3C 01              LDA   |GOS                     ;Make user stack pointer = monitor's
2362 A759              GO816_0_4 EQU   *
2363 A759 28                    PLP                            ;Restore 'c'/'v' status
2364 A75A 48                    PHA                            ;Save 16 bit stack pointer
2365 A75B A3 06                 LDA   6,S                      ;Get monitor data bank register
2366 A75D AA                    TAX                            ;And save for RTL later
2367 A75E 68                    PLA                            ;Recall 16 bit stack pointer
2368 A75F E2 30                 SEP   #$30                     ;Back to 8 bit land
2369 A761 50 03                 BVC   GO816_1_2                ;'v'= 0 if not alternate stack pointer
2370 A763 8D 09 C0              STA   SETALTZP                 ;Now in alternate stack
2371 A766              GO816_1_2 EQU   *
2372 A766 1B                    TCS                            ;Now in user stack space
2373 A767 B0 06                 BCS   GO816_2                  ;'c'=1 for RTS to stack
2374 A769 4B                    PHK                            ;Save return info on stack
2375 A76A F4 B5 A7              PEA   GO816_EXT-1              ;
2376 A76D 90 0E                 BCC   GO816_3                  ;'c'=0 then RTL directly back to monitor
2377 A76F
2378 A76F              GO816_2  EQU   *
2379 A76F 4B                    PHK                            ;Bank to return to
2380 A770 F4 B6 A7              PEA   GO816_EXT                ;Return address
2381 A773 A2 5C                 LDX   #$5C                     ;JMP absolute long opcode
2382 A775 DA                    PHX                            ;Save on stack
2383 A776 F4 18 FB              PEA   $FB18                    ;XCE CLC to stack space
2384 A779 C2 20                 REP   #$20                     ;Do in 16 bit mode
2385 A77B 3B                    TSC                            ;Where will the stack routine be?
2386 A77C 48                    PHA                            ;Save RTS information on stack
2387 A77D              GO816_3  EQU   *
2388 A77D 20 4C 7A              JSR   COMBINEMX                ;{MSA & JOA 3/31/89} Put user's MX into PVAL
2389 A780 3B                    TSC                            ;Alter user stk ptr for our RTS/RTL stuff
2390 A781              GO816_4  EQU   *                        ;Resume continuation entry point
2391 A781 E2 30                 SEP   #$30                     ;8 bit land in here
2392 A783 50 03                 BVC   GO816_5                  ;'v'=0 then main stack is one to use
2393 A785 8D 09 C0              STA   SETALTZP                 ;Now in alternate stack
2394 A788              GO816_5  EQU   *
2395 A788 1B                    TCS                            ;Set proper stack pointer
2396 A789
2397 A789 AD 3C 01              LDA   |GOS                     ;Fix stack pointer in case using alt stk
2398 A78C 8F 00 01 01           STA   >MNEMSTKPTR              ;Put in main stk pointer save address
2399 A790 AC 32 01              LDY   |EPVAL                   ;Native or emulation mode ?
2400 A793 D0 04                 BNE   GO816_6                  ;'Y' = 1 if emulation mode of execution
2401 A795 AD 3E 01              LDA   |BANKS                   ;Native mode, push in program bank
2402 A798 48                    PHA   
2403 A799              GO816_6  EQU   *
2404 A799 C2 20                 REP   #$20                     ;16 bit m
2405 A79B AD 3A 01              LDA   |E1PCLH                  ;Get user's program counter
2406 A79E 48                    PHA                            ;Create user's pc for 'RTI'
2407 A79F E2 30                 SEP   #$30                     ;
2408 A7A1              *
2409 A7A1              * The commented code is reworked so that the check of mode is done before RESTOREFF,
2410 A7A1              *  and to fix the interrupt window anomaly. {MSA/FAB 4/12/89}
2411 A7A1              *
2412 A7A1 AF 32 01 E1           LDA   >EPVAL                   ;Check for emul/native return
2413 A7A5 D0 03                 BNE   GO816_M                  ;It's emulation: must rti from bank $00
2414 A7A7 4C 9C 9F              JMP   MFRTI                    ;Finish up and vector
2415 A7AA              *
2416 A7AA              GO816_M  EQU   *
2417 A7AA AF 2A 01 E1           LDA   >PVAL                    ;Set to pull the user's psreg
2418 A7AE 48                    PHA   
2419 A7AF 20 68 7A              JSR   RESTOREFF                ;Restore regs and set to proper mode also
2420 A7B2              ;PHP  ;Push in as dummy for 'RTI'
2421 A7B2              ;LDA =EPVAL ;Chk for emul/native mode
2422 A7B2              ;BNE GO816.7 ;BRA if in emulation mode
2423 A7B2              ;RTI  ;Go to user's routine in native mode
2424 A7B2              GO816_7  EQU   *
2425 A7B2 5C 72 C0 00           JMP   >RTI~Bnk00               ;Force prog bk=00 and rti to usr's routine
2426 A7B6
2427 A7B6
2428 A7B6              GO816_EXT EQU   *                       ;Restore normal monitor context
2429 A7B6 D8                    CLD                            ;NO NO NO decimal mode in here
2430 A7B7 18                    CLC                            ;Just in case switch to native mode
2431 A7B8 FB                    XCE                            ;
2432 A7B9 E2 30                 SEP   #$30                     ;Always enters in native mode
2433 A7BB 8D 08 C0              STA   SETSTDZP                 ;Arbitrarily force main stack 
2434 A7BE C2 30                 REP   #$30                     ;Off to 16 bit land
2435 A7C0 20 82 F8              JSR   DBTOE1                   ;Force data bank register for softswitches
2436 A7C3 AD 3C 01              LDA   |GOS                     ;Recall stack pointer
2437 A7C6 1B                    TCS                            ;Change to original stack pointer
2438 A7C7 68                    PLA                            ;Recall SHADOW/CYAREG
2439 A7C8 8D 35 C0              STA   SHADOW                   ;
2440 A7CB E2 30                 SEP   #$30                     ;Back to 8 bit land to continue
2441 A7CD
2442 A7CD              * Need to update textp2 shadowing at $c035,  since user can get into 
2443 A7CD              * monitor and call the entry point at $f962.                 
2444 A7CD              * The $f962 is a toggling routine for bit5 of $c035 and therefore
2445 A7CD              * need to update that bit for users' preference.
2446 A7CD
2447 A7CD 20 2E 7A              JSR   SETTEXT2REG              ;User can execute $f962 with 'G' or 'X'
2448 A7D0 F4 00 00              PEA   $0000                    ;Reset direct register
2449 A7D3 2B                    PLD                            ;
2450 A7D4 68                    PLA                            ;Recall STATEREG
2451 A7D5 20 33 B8              JSR   MEMEXIT1                 ;Restore memory state and fix page 1/2
2452 A7D8 AB                    PLB                            ;Recall data bank register
2453 A7D9 60                    RTS                            ;Back to original monitor command line
2454 A7DA
2455 A7DA
2456 A7DA              FIXE1PCLH EQU   *                       ;Move PCL/PCH to bank E1 in case alt zp
2457 A7DA 78                    SEI                            ;Kill interrupts
2458 A7DB 20 62 FE              JSR   A1PC                     ;Set up monitor PCL/PCH
2459 A7DE 20 82 F8              JSR   DBTOE1                   ;Change data bank register to E1
2460 A7E1 E2 40                 SEP   #$40                     ;Anticipate alternate stack pointer
2461 A7E3 AD 2D 01              LDA   |MVAL                    ;See if alternate stack or not
2462 A7E6 30 01                 BMI   FIXE1PCLH2               ;- then alternate stack in use (let 'v'=1)
2463 A7E8 B8                    CLV                            ; else clear 'v' as indicator.
2464 A7E9              FIXE1PCLH2 EQU   *
2465 A7E9 C2 30                 REP   #$30                     ;Off to 16 bit land
2466 A7EB A5 3A                 LDA   PCL                      ;PCL/PCH is stored here
2467 A7ED 8D 3A 01              STA   |E1PCLH                  ;Save in bank E1 for later
2468 A7F0 AD 26 01              LDA   |SVAL                    ;
2469 A7F3 60                    RTS                            ;Back to caller in 16 bit 'm'/'x'
2470 A7F4
2471 A7F4              TEXTPAGE1 EQU   *
2472 A7F4 AF A8 01 E1           LDA   >FLIPSCRN                ;Already called before ?
2473 A7F8 49 80                 EOR   #$80                     ;
2474 A7FA 8F A8 01 E1           STA   >FLIPSCRN
2475 A7FE 30 11                 BMI   BRKSCRN                  ;
2476 A800              SETPAG1  EQU   *
2477 A800 64 22                 STZ   WNDTOP                   ;Reset top of window
2478 A802 A9 80                 LDA   #$80
2479 A804 1C 29 C0              TRB   NEWVIDEO                 ;No super hi res scrn
2480 A807 AD 51 C0              LDA   TXTSET                   ;Enable text
2481 A80A AD 52 C0              LDA   MIXCLR                   ;Clear mixed mode
2482 A80D AD 54 C0              LDA   TXTPAGE1                 ;Enable text page1
2483 A810 60                    RTS   
2484 A811              ;JMP GOTXT1 ;
2485 A811
2486 A811
2487 A811              BRKSCRN  EQU   *
2488 A811 8B                    PHB   
2489 A812 20 82 F8              JSR   DBTOE1
2490 A815                       LONGA OFF
2491 A815                       LONGI OFF
2492 A815 E2 30                 SEP   #$30
2493 A817 AD BB 01              LDA   |SCRNSTAT                ;
2494 A81A 48                    PHA   
2495 A81B 29 80                 AND   #$80
2496 A81D 0D 29 C0              ORA   |NEWVIDEO
2497 A820 8D 29 C0              STA   |NEWVIDEO
2498 A823 68                    PLA   
2499 A824 0A                    ASL   A
2500 A825 10 05                 BPL   @4
2501 A827 8D 51 C0              STA   |TXTSET
2502 A82A 80 03                 BRA   @5
2503 A82C 8D 50 C0     @4       STA   |TXTCLR
2504 A82F 0A           @5       ASL   A
2505 A830 10 05                 BPL   @6
2506 A832 8D 53 C0              STA   |MIXSET
2507 A835 80 03                 BRA   @7
2508 A837 8D 52 C0     @6       STA   |MIXCLR
2509 A83A 0A           @7       ASL   A
2510 A83B 10 05                 BPL   @8
2511 A83D 8D 57 C0              STA   |HIRES
2512 A840 80 03                 BRA   @9
2513 A842 8D 56 C0     @8       STA   |LORES
2514 A845 0A           @9       ASL   A
2515 A846 10 05                 BPL   @10
2516 A848 8D 55 C0              STA   |TXTPAGE2
2517 A84B 80 03                 BRA   @11
2518 A84D 8D 54 C0     @10      STA   |TXTPAGE1
2519 A850 AB           @11      PLB   
2520 A851              UT9      EQU   *
2521 A851 60                    RTS   
2522 A852
2523 A852                       EJECT 
2524 A852              * Utility calls to Tools is done in 2 steps.
2525 A852              * 1. Set up the information for the tool call JSL in
2526 A852              *    the input buffer in this order.
2527 A852              * 2. Do the actual utility call after the user types in
2528 A852              *    the tool information and a 'U'.
2529 A852              *
2530 A852              * Utility call format is as follows ('_' denotes a required space)
2531 A852              * \#bytes to stk_#bytes frm stk_parm1_.._parmz_function#_tool#\U
2532 A852              *
2533 A852              * NOTE: Each byte of each paramter must be separated by a space
2534 A852              *
2535 A852              * '\' starts and '\' terminates tool setup information normally.
2536 A852              * $8D terminates the entire line and reenters the monitor.
2537 A852
2538 A852              UTILITYFF EQU   *
2539 A852
2540 A852 C2 30                 REP   #$30                     ;Off to 16 bit land
2541 A854 AD 01 02              LDA   IN+1                     ;# of bytes to push on stack for call
2542 A857 8F 3C 01 E1           STA   >GOS                     ; and # of bytes to print after call.
2543 A85B E2 30                 SEP   #$30                     ;8 bit land now
2544 A85D A8                    TAY                            ;# of bytes for stack-2
2545 A85E C8                    INY                            ;Inc by 2 for function # and tool #
2546 A85F C8                    INY                            ;
2547 A860 A2 00                 LDX   #$00                     ;Read input buffer index
2548 A862              UT2      EQU   *
2549 A862 BD 03 02              LDA   IN+3,X                   ;Get byte for stack
2550 A865 48                    PHA                            ; and place it there.
2551 A866 E8                    INX                            ;Next character position in input buffer
2552 A867 88                    DEY                            ;
2553 A868 D0 F8                 BNE   UT2                      ;Loop til done
2554 A86A C2 30                 REP   #$30                     ;Must be 16 bit land to call tools
2555 A86C FA                    PLX                            ;'X' has tool# in hi byte func# in lo byte
2556 A86D 22 00 00 E1           JSL   >DISPATCH1               ;Call tool
2557 A871 48                    PHA                            ;Save result status for later
2558 A872 48                    PHA                            ;Save error code on stack
2559 A873 E2 30                 SEP   #$30                     ;Back to 8 bit land
2560 A875 20 CF A9              JSR   CROUTFF                  ;Next line please
2561 A878 A9 0B                 LDA   #TLERRMSG                ;'Tool error= ' message
2562 A87A 20 80 C0              JSR   PRINTMSG                 ;
2563 A87D FA                    PLX                            ;Recall lo byte of error code to print
2564 A87E 7A                    PLY                            ;Recall hi byte of error code to print
2565 A87F 20 9E A9              JSR   PRNTYXFF                 ;Print 'Y' 1st then 'X'
2566 A882 20 CF A9              JSR   CROUTFF                  ;Next line please
2567 A885 C2 30                 REP   #$30                     ;16 bit land to do testing
2568 A887 68                    PLA                            ;Recall result status lo byte
2569 A888 F0 0B                 BEQ   UT4                      ;=0 then no error clean up
2570 A88A                       LONGA ON
2571 A88A C9 10 00              CMP   #$0010                   ;0<Error<10 then dispatcher error
2572 A88D                       LONGA OFF
2573 A88D B0 06                 BCS   UT4                      ;= of >$10 then do not clean up
2574 A88F AF 3C 01 E1           LDA   >GOS                     ;Pull old data from stack and display
2575 A893 80 04                 BRA   UT5                      ;
2576 A895
2577 A895              UT4      EQU   *
2578 A895 AF 3D 01 E1           LDA   >GOS+1                   ;Pull resultant data from stack/display
2579 A899              UT5      EQU   *
2580 A899 E2 30                 SEP   #$30                     ;8 bit land for regular monitor stuff
2581 A89B A8                    TAY                            ;Lo byte is # of bytes pushed earlier
2582 A89C              UT6      EQU   *
2583 A89C F0 B3                 BEQ   UT9                      ;=0 then no parameters on stack
2584 A89E 88                    DEY                            ;Decrement counter
2585 A89F 68                    PLA                            ;Recall byte to print
2586 A8A0 5A                    PHY                            ;Save counter
2587 A8A1 20 A3 A9              JSR   PRBYTEFF                 ;Show user byte
2588 A8A4 20 91 AC              JSR   PR1BLNKFF                ;Space between data
2589 A8A7 7A                    PLY                            ;Recall index
2590 A8A8 80 F2                 BRA   UT6                      ;Loop til done
2591 A8AA
2592 A8AA                       EJECT 
2593 A8AA              * TCMD has two functions.
2594 A8AA              *    1.  Read and display time
2595 A8AA              *    2.  Set time
2596 A8AA              *
2597 A8AA              * Format to read and display time is
2598 A8AA              *
2599 A8AA              *     '=T'
2600 A8AA              *
2601 A8AA              *  Where 'T' must be upper case.
2602 A8AA              *
2603 A8AA              * Display format is
2604 A8AA              * 
2605 A8AA              * 'Time-> nn/dd/yy hh:mm:ss am/pm'
2606 A8AA              *
2607 A8AA              * Format to set time is
2608 A8AA              *
2609 A8AA              *    '=T=nn dd yy hh mm ss
2610 A8AA              *
2611 A8AA              *  Where 'T' must be upper case.
2612 A8AA              *  Any valid delimiter except ' and carriage return
2613 A8AA              *    may be used in place of the spaces between
2614 A8AA              *    variables as shown above.
2615 A8AA              *  Value-->>    User Enters   To Routine
2616 A8AA              *  nn = month     (1-12)        (0-11)
2617 A8AA              *  dd = day       (1-31)        (0-30)
2618 A8AA              *  yy = year      (0-99)        (0-99)
2619 A8AA              *  hh = hours     (0-23)        (0-23)
2620 A8AA              *  mm = minutes   (0-59)        (0-59)
2621 A8AA              *  ss = seconds   (0-59)        (0-59)
2622 A8AA              *
2623 A8AA              * The line must be terminated with a carriage return.
2624 A8AA              * If the line is terminated without entering all
2625 A8AA              *  the variables, the missing variables will not be
2626 A8AA              *  changed.
2627 A8AA              * The user entered values are converted then placed
2628 A8AA              * on the stack and the Miscellaneous Tools is
2629 A8AA              * called to set the clock chip time.  The calls to
2630 A8AA              * write and read the clock chip via the Miscellaneous
2631 A8AA              * Tools.
2632 A8AA              *
2633 A8AA              * ReadAsciiTime -- Function number RATFN
2634 A8AA              *      Input stack:  SP+4 = Null
2635 A8AA              *                    SP+3 = ASCII buffer bank number
2636 A8AA              *                    SP+2 = ASCII buffer hi byte of address
2637 A8AA              *                    SP+1 = ASCII buffer lo byte of address
2638 A8AA              *                          
2639 A8AA              *      PEA $0000+^ASCIITIME ;Null byte + bank number
2640 A8AA              *      PEA ASCIITIME ;Address of buffer
2641 A8AA              *      INDEX16
2642 A8AA              *      LDX #RATFN*256+MTN  ;Function number*256 + Misc Tool number
2643 A8AA              *      INDEX8
2644 A8AA              *      JSL =DISPATCH1  ;Call main Tool Locator
2645 A8AA              *
2646 A8AA              *      Return data is in buffer ASCIITIME
2647 A8AA              *
2648 A8AA              * ReadTimeHex -- Function number RTHFN
2649 A8AA              *     Input stack:   SP+8 = Push room for day of week 0=Sunday
2650 A8AA              *                    SP+7 = Push room for null byte
2651 A8AA              *                    SP+6 = Push room for month
2652 A8AA              *                    SP+5 = Push room for day
2653 A8AA              *                    SP+4 = Push room for year
2654 A8AA              *                    SP+3 = Push room for hour
2655 A8AA              *                    SP+2 = Push room for minute
2656 A8AA              *                    SP+1 = Push room for second
2657 A8AA              *
2658 A8AA              *      Push room for day of week on stack 0=Sunday
2659 A8AA              *      Push room for null byte on stack
2660 A8AA              *      Push room for month on stack
2661 A8AA              *      Push room for day on stack
2662 A8AA              *      Push room for year on stack
2663 A8AA              *      Push room for hour on stack
2664 A8AA              *      Push room for minute on stack
2665 A8AA              *      Push room for second on stack
2666 A8AA              *      INDEX16
2667 A8AA              *      LDX #RTHFN*256+MTN  ;Function number*256 + Misc Tool number
2668 A8AA              *      INDEX8
2669 A8AA              *      JSL =DISPATCH1  ;Call main Tool Locator
2670 A8AA              *
2671 A8AA              *      Pull second from stack
2672 A8AA              *      Pull minute from stack
2673 A8AA              *      Pull hour from stack
2674 A8AA              *      Pull year from stack
2675 A8AA              *      Pull day from stack
2676 A8AA              *      Pull month from stack
2677 A8AA              *      Pull null byte from stack
2678 A8AA              *      Pull day of week from stack 0=Sunday
2679 A8AA              *
2680 A8AA              * WriteTimeHex -- Function number WTHFN
2681 A8AA              *      Input stack:  SP+6 = Month
2682 A8AA              *                    SP+5 = Day
2683 A8AA              *                    SP+4 = Year
2684 A8AA              *                    SP+3 = Hour
2685 A8AA              *                    SP+2 = Minute
2686 A8AA              *                    SP+1 = Second
2687 A8AA              *
2688 A8AA              *      Push month on stack
2689 A8AA              *      Push day on stack
2690 A8AA              *      Push year on stack
2691 A8AA              *      Push hours on stack
2692 A8AA              *      Push minutes on stack
2693 A8AA              *      Push seconds on stack
2694 A8AA              *      INDEX16
2695 A8AA              *      LDX #WTHFN*256+MTN  ;Function number*256 + Misc Tool number
2696 A8AA              *      INDEX8
2697 A8AA              *      JSL =DISPATCH1  ;Call main Tool Locator
2698 A8AA              *
2699 A8AA              *             No values are returned from this call.
2700 A8AA              *
2701 A8AA
2702 A8AA              TCMD     EQU   *                        ;Display current time command
2703 A8AA 20 1D A9              JSR   PRINTTIME                ;Print original time
2704 A8AD A4 34                 LDY   YSAV                     ;Pick up where MONZ left off
2705 A8AF B9 00 02              LDA   IN,Y                     ;Test for '=' to see if setting time
2706 A8B2 C9 BD                 CMP   #'='                     ;'=' required for setting time
2707 A8B4 D0 9B                 BNE   UT9                      ;<>'=' then done so exit with RTS
2708 A8B6 E6 34                 INC   YSAV                     ;Point to next item in input buffer
2709 A8B8 9C 00 02              STZ   IN                       ;Counter for number of bytes entered
2710 A8BB              TCMD2    EQU   *                        ;Display current time command
2711 A8BB A4 34                 LDY   YSAV                     ;Pick up where MONZ left off
2712 A8BD 20 4B B2              JSR   GETNUMFF                 ;Get next entry
2713 A8C0 84 34                 STY   YSAV                     ;Save pointer for later
2714 A8C2 C9 C6                 CMP   #$C6                     ;Was it a carriage return?
2715 A8C4 F0 29                 BEQ   TCMD6                    ;
2716 A8C6 20 4C A9              JSR   CDECTOHEX                ;Clock decimal to hex time conversion
2717 A8C9 F0 F0                 BEQ   TCMD2                    ;'z'=1 then it's a delimiter to be skipped
2718 A8CB 48                    PHA                            ;Save result on stack for tool call
2719 A8CC AD 00 02              LDA   IN                       ;Test # of values entered
2720 A8CF C9 02                 CMP   #$02                     ;If 0/1 then decrement entered value by 1
2721 A8D1 B0 03                 BCS   TCMD5                    ;
2722 A8D3 FA                    PLX                            ;Recall value entered and subtract 1
2723 A8D4 CA                    DEX                            ;
2724 A8D5 DA                    PHX                            ;Restore value to stack
2725 A8D6              TCMD5    EQU   *
2726 A8D6 C9 02                 CMP   #$02                     ;If 2 then it's year so modify if needed
2727 A8D8 D0 0C                 BNE   TCMD5_5                  ;
2728 A8DA 68                    PLA                            ;Recall saved year
2729 A8DB C9 28                 CMP   #40                      ;=<40 the add $64
2730 A8DD B0 03                 BCS   @2                       ;
2731 A8DF              @1       EQU   *
2732 A8DF 18                    CLC                            ;Add 100 to get to the year 2000+
2733 A8E0 69 64                 ADC   #$64                     ;
2734 A8E2              @2       EQU   *
2735 A8E2 48                    PHA                            ;Restore modified year
2736 A8E3 AD 00 02              LDA   IN                       ;'A'=# of values entered
2737 A8E6              TCMD5_5  EQU   *
2738 A8E6 C9 06                 CMP   #$06                     ;If 6 entered then we're done
2739 A8E8 B0 22                 BCS   TCMD9                    ;
2740 A8EA EE 00 02              INC   IN                       ;If not done increment value entry counter
2741 A8ED 80 CC                 BRA   TCMD2                    ; and go for another value.
2742 A8EF
2743 A8EF              TCMD6    EQU   *
2744 A8EF 20 4C A9              JSR   CDECTOHEX                ;Clock decimal to hex time conversion
2745 A8F2 F0 04                 BEQ   TCMD6_2                  ;'z'=1 then no values entered
2746 A8F4 48                    PHA                            ; else save last entered value on stack
2747 A8F5 EE 00 02              INC   IN                       ; and increment counter.
2748 A8F8              TCMD6_2  EQU   *
2749 A8F8 AE 00 02              LDX   IN                       ;Put entry counter into 'X'
2750 A8FB E0 06                 CPX   #$06                     ;=6 then all's fine so write it
2751 A8FD B0 0D                 BCS   TCMD9                    ;
2752 A8FF              TCMD7    EQU   *
2753 A8FF 8A                    TXA                            ;Test 'X' for 0 value
2754 A900 F0 04                 BEQ   TCMD8                    ;Take error exit
2755 A902 68                    PLA                            ;Clean 1 byte off stack
2756 A903 CA                    DEX                            ;
2757 A904 80 F9                 BRA   TCMD7                    ;Loop back always
2758 A906
2759 A906              TCMD8    EQU   *                        ;Error exit
2760 A906 20 51 9A              JSR   NEWBELL1                 ;Beep bell and exit
2761 A909 4C 4D A3              JMP   MONZ2RTN                 ;Back via new monitor entry line
2762 A90C
2763 A90C              TCMD9    EQU   *
2764 A90C C2 30                 REP   #$30                     ;All tool calls are 16 bits
2765 A90E                       LONGI ON
2766 A90E A2 03 0E              LDX   #WTHFN*256+MTN           ;Function number/tool number
2767 A911                       LONGI OFF
2768 A911
2769 A911 22 00 00 E1           JSL   >DISPATCH1               ;Go set time with 16 bit 'm'/'x'
2770 A915
2771 A915 E2 30                 SEP   #$30                     ;Back to 8 bit 'm'/'x' for monitor
2772 A917
2773 A917
2774 A917 20 1D A9              JSR   PRINTTIME                ;Print changed time for user
2775 A91A 4C 4D A3              JMP   MONZ2RTN                 ;Return to monitor command line directly
2776 A91D
2777 A91D
2778 A91D              PRINTTIME EQU   *
2779 A91D 20 CF A9              JSR   CROUTFF                  ;Next line please
2780 A920 A9 04                 LDA   #TIMEMSG                 ;Number of characters in message
2781 A922 20 80 C0              JSR   PRINTMSG                 ;Print message
2782 A925 08                    PHP                            ;Disable interrupts for a while
2783 A926 78                    SEI                            ;
2784 A927 F4 E1 00              PEA   ASCIITIME>>16            ;Null/bank number of buffer
2785 A92A F4 08 01              PEA   |ASCIITIME               ;Address of buffer
2786 A92D C2 30                 REP   #$30                     ;All tool calls are 16 bits
2787 A92F                       LONGI ON
2788 A92F A2 03 0F              LDX   #RATFN*256+MTN           ;Function number/tool number
2789 A932                       LONGI OFF
2790 A932
2791 A932 22 00 00 E1           JSL   >DISPATCH1               ;Go set time with 16 bit 'm'/'x'
2792 A936
2793 A936 E2 30                 SEP   #$30                     ;Back to 8 bit 'm'/'x' for monitor
2794 A938
2795 A938 A2 00                 LDX   #$00                     ;20 bytes of time to display
2796 A93A              PRTIMELP EQU   *
2797 A93A BF 08 01 E1           LDA   >ASCIITIME,X             ;
2798 A93E DA                    PHX                            ;Save print index
2799 A93F 20 D1 A9              JSR   COUTFF                   ;
2800 A942 FA                    PLX                            ;Recall index
2801 A943 E8                    INX                            ;Next character please
2802 A944 E0 14                 CPX   #$14                     ;Test for done
2803 A946 90 F2                 BCC   PRTIMELP                 ;Loop til 4 bytes printed
2804 A948 28                    PLP                            ;Restore interrupt status
2805 A949 4C CF A9              JMP   CROUTFF                  ;Next line please
2806 A94C
2807 A94C
2808 A94C              CDECTOHEX EQU   *
2809 A94C AF 42 01 E1           LDA   >DIGITCNT                ;=0 if no hex digits entered
2810 A950 08                    PHP                            ;Sve 'z' to enable delimiter to be skipped
2811 A951 A5 3E                 LDA   A2L                      ;Get low byte of hex value entered
2812 A953 48                    PHA                            ;Save on stack
2813 A954 29 0F                 AND   #$0F                     ;Work with low byte 1st
2814 A956 85 3E                 STA   A2L                      ;Save for SUMEM
2815 A958 68                    PLA                            ;Recall original entry
2816 A959 20 7B F8              JSR   SCRN4                    ; and move hi nybble to low nybble.
2817 A95C AA                    TAX                            ;Then put result in 'X' for SUMEM
2818 A95D 20 64 A9              JSR   SUM0A                    ;Create hex number from decimal number
2819 A960 A5 3E                 LDA   A2L                      ;Sum is placed here in SUMEM
2820 A962 28                    PLP                            ;'z'=1 then skip delimiter
2821 A963 60                    RTS                            ;Back to caller
2822 A964
2823 A964              SUM0A    EQU   *                        ;Sum using $0A as summing value
2824 A964 A9 0A                 LDA   #$0A                     ;
2825 A966 85 3C                 STA   A1L                      ;Save 'A'
2826 A968              SUMEM1   EQU   *
2827 A968 A5 3C                 LDA   A1L                      ;Recall number to add
2828 A96A 18                    CLC                            ;Prepare to add
2829 A96B CA                    DEX                            ;Check to see if done
2830 A96C 30 06                 BMI   SUMEMDNE                 ;'-' when done
2831 A96E 65 3E                 ADC   A2L                      ;Add running total to accumulator
2832 A970 85 3E                 STA   A2L                      ; and save in total.
2833 A972 80 F4                 BRA   SUMEM1                   ;Loop to add more
2834 A974
2835 A974              SUMEMDNE EQU   *
2836 A974 60                    RTS                            ;Back to caller
2837 A975
2838 A975
2839 A975
2840 A975
2841 A975                       TITLE 'Reverse Dispatcher'
2842 A975
2843 A975              ******************************************************
2844 A975              *                                                    *
2845 A975              *  Reverse Dispatch to Routines in //e Monitor Space *
2846 A975              *                                                    *
2847 A975              *               by                                   *
2848 A975              *          Fern Bachman     1985-1987                *
2849 A975              *          Joe Bo           1987-1989                *
2850 A975              *                                                    *
2851 A975              *       Copyright Apple Computer, Inc. 1985-1989     *
2852 A975              *                All Rights Reserved.                *
2853 A975              *                                                    *
2854 A975              ******************************************************
2855 A975
2856 A975
2857 A975              UPFF     EQU   *
2858 A975 F4 19 FC              PEA   UP-1                     ;Push address of rtne to execute on stack
2859 A978 80 2C                 BRA   TOMAINSIDE               ;Go to mainside 
2860 A97A
2861 A97A
2862 A97A              * print the address in the form bb/aaaa:
2863 A97A
2864 A97A 20 86 A9     PRADDR   JSR   PRBANKS
2865 A97D A6 3C                 LDX   A1L
2866 A97F A4 3D                 LDY   A1H
2867 A981              XPRADDRFF EQU   *
2868 A981 F4 98 FD              PEA   XPRADDR-1                ;Push address of rtne to execute on stack
2869 A984 80 20                 BRA   TOMAINSIDE               ;Go to mainside 
2870 A986
2871 A986              * print the bank number bb
2872 A986
2873 A986              PRBANKS  EQU   *
2874 A986 20 CF A9              JSR   CROUTFF                  ;Output a carriage return
2875 A989 AF 3E 01 E1           LDA   >BANKS                   ;Get source bank number
2876 A98D 20 A3 A9              JSR   PRBYTEFF                 ;Show user bank number
2877 A990 A9 AF                 LDA   #$AF                     ;'/'
2878 A992 80 3D                 BRA   COUTFF                   ;
2879 A994
2880 A994
2881 A994              GETLNZFF EQU   *
2882 A994 F4 66 FD              PEA   GETLNZ-1                 ;Push address of rtne to execute on stack
2883 A997 80 0D                 BRA   TOMAINSIDE               ;Go to mainside 
2884 A999
2885 A999
2886 A999              PRHEXFF  EQU   *
2887 A999 F4 E2 FD              PEA   PRHEX-1                  ;Push address of rtne to execute on stack
2888 A99C 80 08                 BRA   TOMAINSIDE               ;Go to mainside 
2889 A99E
2890 A99E
2891 A99E              PRNTYXFF EQU   *
2892 A99E 98                    TYA                            ;Y to A to print
2893 A99F              PRNTAXFF EQU   *
2894 A99F 20 A3 A9              JSR   PRBYTEFF                 ;
2895 A9A2 8A                    TXA                            ;X to A to print
2896 A9A3
2897 A9A3              PRBYTEFF EQU   *
2898 A9A3 F4 D9 FD              PEA   PRBYTE-1                 ;Push address of rtne to execute on stack
2899 A9A6
2900 A9A6              TOMAINSIDE EQU   *
2901 A9A6 5C 9C 01 E1           JMP   >MAINSIDEPATCH           ;Make it patchable
2902 A9AA
2903 A9AA                                                      ; SEG $FF
2904 A9AA              TOMAINSIDE1 EQU   *
2905 A9AA                                                      ; SEG $00
2906 A9AA EB                    XBA                            ;Preserve 'A' in 'B'
2907 A9AB 8A                    TXA                            ;Preserve 'X' in 'A'
2908 A9AC C2 30                 REP   #$30                     ;Off to 16 bit land
2909 A9AE FA                    PLX                            ;Recall and save routine address in 'X'
2910 A9AF 4B                    PHK                            ;Return bank
2911 A9B0 F4 20 9C              PEA   FFBANKRTS-1              ;Return address in bank FF
2912 A9B3 F4 D3 F8              PEA   MAINEXIT-1               ;Exit point in main monitor ROM
2913 A9B6 DA                    PHX                            ;Routine to execute back to stack
2914 A9B7 E2 30                 SEP   #$30                     ;Back to 8 bit land
2915 A9B9 AA                    TAX                            ;Restore 'X' from 'A'
2916 A9BA EB                    XBA                            ;Restore 'A' from 'B'
2917 A9BB              TOMAINSIDE2 EQU   *                     ;Special entry point
2918 A9BB EB                    XBA                            ;Save 'A' value
2919 A9BC 20 D6 FF              JSR   FIXSPEED                 ;Make non bank FF speed user speed!
2920 A9BF EB                    XBA                            ;Restore user 'A' value
2921 A9C0 8B                    PHB                            ;Data bank register is new program bank
2922 A9C1 F4 B4 F8              PEA   MAINSIDE-1               ;Main ROM area entry point
2923 A9C4 8D 06 C0              STA   SETSLOTCXROM             ;Disable internal CxROM
2924 A9C7 6B                    RTL                            ;Go to mainside 
2925 A9C8
2926 A9C8
2927 A9C8              PRBLNKFF EQU   *
2928 A9C8 A2 03                 LDX   #$03                     ;3 blanks to fall into PRBL2
2929 A9CA
2930 A9CA
2931 A9CA              PRBL2FF  EQU   *
2932 A9CA F4 49 F9              PEA   PRBL2-1                  ;Push address of rtne to execute on stack
2933 A9CD 80 D7                 BRA   TOMAINSIDE               ;Go to mainside 
2934 A9CF
2935 A9CF
2936 A9CF              CROUTFF  EQU   *                        ;Output a carriage return
2937 A9CF A9 8D                 LDA   #$8D                     ;
2938 A9D1
2939 A9D1              COUTFF   EQU   *
2940 A9D1 F4 EC FD              PEA   COUT-1                   ;Push address of rtne to execute on stack
2941 A9D4 80 D0                 BRA   TOMAINSIDE               ;Go to mainside 
2942 A9D6
2943 A9D6
2944 A9D6              COUT1FF  EQU   *
2945 A9D6 F4 EF FD              PEA   COUT1-1                  ;Push address of rtne to execute on stack
2946 A9D9 80 CB                 BRA   TOMAINSIDE               ;Go to mainside 
2947 A9DB
2948 A9DB
2949 A9DB              MONZ2FF  EQU   *
2950 A9DB F4 6B FF              PEA   MONZ2-1                  ;Push address of rtne to execute on stack
2951 A9DE 80 DB                 BRA   TOMAINSIDE2              ;Go to mainside 
2952 A9E0
2953 A9E0
2954 A9E0              SETVTAB  EQU   *
2955 A9E0 86 24                 STX   CH                       ;Set cursor horizontal position
2956 A9E2 84 25                 STY   CV                       ;Set cursor vertical position
2957 A9E4
2958 A9E4              VTABFF   EQU   *
2959 A9E4 F4 21 FC              PEA   VTAB-1                   ;Push address of rtne to execute on stack
2960 A9E7 80 BD                 BRA   TOMAINSIDE               ;Go to main side
2961 A9E9
2962 A9E9
2963 A9E9              C300FF   EQU   *
2964 A9E9 F4 FF C2              PEA   C300-1                   ;Push address of rtne to execute on stack
2965 A9EC 80 B8                 BRA   TOMAINSIDE               ;Go to main side
2966 A9EE
2967 A9EE
2968 A9EE              HOMEFF   EQU   *
2969 A9EE F4 57 FC              PEA   HOME-1                   ;Push address of rtne to execute on stack
2970 A9F1 80 B3                 BRA   TOMAINSIDE               ;Go to main side
2971 A9F3
2972 A9F3
2973 A9F3              SETVIDKBDFF EQU   *
2974 A9F3 F4 42 FE              PEA   SETVIDKBD-1              ;Push address of rtne to execute on stack
2975 A9F6 80 AE                 BRA   TOMAINSIDE               ;Go to main side
2976 A9F8
2977 A9F8
2978 A9F8              ENTER80  EQU   *
2979 A9F8 A9 98                 LDA   #$98                     ;Output control-X to cancel line
2980 A9FA 20 E9 A9              JSR   C300FF                   ;Enable 80 columns
2981 A9FD A9 00                 LDA   #$00                     ;Reset flag
2982 A9FF 8F 37 01 E1           STA   >CHGCURFLG               ;Reset cursor/80 column change flag
2983 AA03 60                    RTS                            ;Back to caller with 'A'=0
2984 AA04
2985 AA04
2986 AA04
2987 AA04                       TITLE 'Examine Memory Routines'
2988 AA04
2989 AA04              ******************************************************
2990 AA04              *                                                    *
2991 AA04              *        Examine Any Memory in System Routines       *
2992 AA04              *                                                    *
2993 AA04              *                    by                              *
2994 AA04              *               Fern Bachman     1985-1987           *
2995 AA04              *               Joe Bo           1987-1989           *
2996 AA04              *                                                    *
2997 AA04              *       Copyright Apple Computer, Inc. 1985-1989     *
2998 AA04              *                All Rights Reserved.                *
2999 AA04              *                                                    *
3000 AA04              ******************************************************
3001 AA04
3002 AA04              XMEMORY  EQU   *
3003 AA04 AF 3E 01 E1           LDA   >BANKS                   ;CHK FOR CROSS BANK, get start bank first
3004 AA08 CF A7 01 E1           CMP   >HIGHBANK                ;
3005 AA0C F0 06                 BEQ   @00                      ;NO CROSS BANK
3006 AA0E 90 26                 BCC   @01                      ;BRA TO SET UP FOR CROSSING BANK
3007 AA10 64 3E                 STZ   A2L                      ;Need to fool around for NXTA1
3008 AA12 64 3F                 STZ   A2H                      ;
3009 AA14
3010 AA14              @00      EQU   *
3011 AA14 20 7A A9              JSR   PRADDR
3012 AA17 A5 3D                 LDA   A1H
3013 AA19 85 43                 STA   A4H
3014 AA1B A5 3C                 LDA   A1L
3015 AA1D 85 42                 STA   A4L
3016 AA1F 20 E7 B7     @0       JSR   READBYT1
3017 AA22 20 A3 A9              JSR   PRBYTEFF                 ;OUTPUT BYTE IN HEX
3018 AA25              @02      EQU   *
3019 AA25 20 BA FC              JSR   NXTA1
3020 AA28 B0 1A                 BCS   @1
3021 AA2A 20 75 FE              JSR   DSPCOUNT
3022 AA2D 25 3C                 AND   A1L
3023 AA2F F0 13                 BEQ   @1
3024 AA31 20 91 AC              JSR   PR1BLNKFF
3025 AA34 80 E9                 BRA   @0                       ;NOT DONE YET. MORE
3026 AA36
3027 AA36              @01      EQU   *
3028 AA36 A5 3F                 LDA   A2H                      ;Temp store A2 and set to $ffff of that bank
3029 AA38 48                    PHA   
3030 AA39 A5 3E                 LDA   A2L
3031 AA3B 48                    PHA   
3032 AA3C A9 FF                 LDA   #$FF
3033 AA3E 85 3F                 STA   A2H
3034 AA40 85 3E                 STA   A2L
3035 AA42              @100     EQU   *
3036 AA42 80 D0                 BRA   @00
3037 AA44
3038 AA44 A5 43        @1       LDA   A4H
3039 AA46 85 3D                 STA   A1H
3040 AA48 A5 42                 LDA   A4L
3041 AA4A 85 3C                 STA   A1L
3042 AA4C A9 AD                 LDA   #$AD                     ;Print '-'
3043 AA4E 20 D1 A9              JSR   COUTFF                   ;
3044 AA51              @2       EQU   *
3045 AA51 20 E9 B7              JSR   READBYTE
3046 AA54 09 80                 ORA   #$80
3047 AA56 C9 A0                 CMP   #$A0
3048 AA58 90 04                 BCC   @3
3049 AA5A C9 FF                 CMP   #$FF
3050 AA5C D0 02                 BNE   @4
3051 AA5E              @3       EQU   *
3052 AA5E A9 AE                 LDA   #$AE                     ;'.'
3053 AA60              @4       EQU   *
3054 AA60 A8                    TAY                            ;Preserve 'A'
3055 AA61 A5 24                 LDA   CH                       ;Test for back up 1 line
3056 AA63 F0 0F                 BEQ   @5                       ;=0 then doing 80 column stuff
3057 AA65 C9 27                 CMP   #39                      ;Test for last column
3058 AA67 08                    PHP                            ;Save result status
3059 AA68 98                    TYA                            ;Recall user byte
3060 AA69 20 D1 A9              JSR   COUTFF                   ;
3061 AA6C 28                    PLP                            ;
3062 AA6D 90 09                 BCC   @5_2                     ;C=0 then not on last column
3063 AA6F 20 75 A9              JSR   UPFF
3064 AA72 80 04                 BRA   @5_2                     ;Skip another output
3065 AA74
3066 AA74              @5       EQU   *
3067 AA74 98                    TYA                            ;Recall 'A' value
3068 AA75 20 D1 A9              JSR   COUTFF
3069 AA78
3070 AA78              @5_2     EQU   *
3071 AA78              ;LDA KBD ;Test for stop list
3072 AA78              ;AND #$7F ;Ignore hi bit
3073 AA78              ;CMP #$18 ;Control-X to stop list
3074 AA78              ;BNE @6 ;<>= then continue list
3075 AA78              ;BIT KBDSTRB ; else clear strobe and quit
3076 AA78 20 74 CF              JSR   XRDKBD                   ;Read keyboard
3077 AA7B 10 22                 BPL   @6                       ;BRA if no keyhit
3078 AA7D 29 7F                 AND   #$7F                     ;Ignore hi bit
3079 AA7F C9 18                 CMP   #$18                     ;CHK for Control-X to stop list
3080 AA81 F0 0B                 BEQ   @5_25                    ;BRA if so
3081 AA83 C9 13                 CMP   #$13                     ;Chk for Ctrl-S to pause
3082 AA85 D0 18                 BNE   @6                       ;Continue list if niether
3083 AA87 20 74 CF     @5_23    JSR   XRDKBD                   ;See if we can continue
3084 AA8A 10 FB                 BPL   @5_23                    ;Keep looping if not
3085 AA8C 80 11                 BRA   @6                       ;Continue with listing
3086 AA8E              @5_25    EQU   *
3087 AA8E AF 3E 01 E1           LDA   >BANKS                   ;Chk if banks = extendbank
3088 AA92 CF A7 01 E1           CMP   >HIGHBANK                ;
3089 AA96 F0 06                 BEQ   @5_3                     ;BRA if already at the same bank
3090 AA98              *
3091 AA98 8F A7 01 E1           STA   >HIGHBANK                ;Force high bank = low bank
3092 AA9C 68                    PLA                            ;Else cross bank exists and low bank
3093 AA9D 68                    PLA                            ; not yet gets to the high bank, cln stk
3094 AA9E              @5_3     EQU   *
3095 AA9E 60                    RTS                            ;
3096 AA9F
3097 AA9F              @6       EQU   *
3098 AA9F 20 BA FC              JSR   NXTA1
3099 AAA2 B0 09                 BCS   @7                       ;Bra to adjust bank crossing
3100 AAA4 20 75 FE              JSR   DSPCOUNT
3101 AAA7 25 3C                 AND   A1L
3102 AAA9 D0 A6                 BNE   @2
3103 AAAB              @8       EQU   *
3104 AAAB 80 95                 BRA   @100
3105 AAAD
3106 AAAD              @7       EQU   *
3107 AAAD 8B                    PHB   
3108 AAAE 20 82 F8              JSR   DBTOE1
3109 AAB1 EE 3E 01              INC   |BANKS
3110 AAB4 AD 3E 01              LDA   |BANKS
3111 AAB7 F0 1D                 BEQ   @10                      ;CHK if already passes $ff bank
3112 AAB9 CD A7 01              CMP   |HIGHBANK                ;
3113 AABC F0 0F                 BEQ   @9
3114 AABE B0 16                 BCS   @10                      ; 
3115 AAC0 AB                    PLB   
3116 AAC1 64 3D                 STZ   A1H                      ;And set the start address to 0
3117 AAC3 64 3C                 STZ   A1L
3118 AAC5 A9 FF                 LDA   #$FF
3119 AAC7 85 3F                 STA   A2H                      ;And reset end address againg to $ffff
3120 AAC9 85 3E                 STA   A2L
3121 AACB 80 DE                 BRA   @8
3122 AACD              @9       EQU   *
3123 AACD AB                    PLB   
3124 AACE 68                    PLA   
3125 AACF 85 3E                 STA   A2L
3126 AAD1 68                    PLA   
3127 AAD2 85 3F                 STA   A2H
3128 AAD4 80 D5                 BRA   @8
3129 AAD6              @10      EQU   *
3130 AAD6 CE 3E 01              DEC   |BANKS                   ;Stay to its last bank and exit
3131 AAD9 AF 3E 01 E1           LDA   >BANKS
3132 AADD 8F A7 01 E1           STA   >HIGHBANK                ;Force high bank = src bank
3133 AAE1 AB                    PLB   
3134 AAE2 60                    RTS   
3135 AAE3
3136 AAE3              PCYTOA3  EQU   *
3137 AAE3 C2 20                 REP   #$20
3138 AAE5 18                    CLC   
3139 AAE6 98                    TYA   
3140 AAE7 65 3A                 ADC   PCL
3141 AAE9 85 40                 STA   A3L
3142 AAEB E2 20                 SEP   #$20
3143 AAED A2 40                 LDX   #A3L
3144 AAEF 60                    RTS   
3145 AAF0
3146 AAF0
3147 AAF0
3148 AAF0
3149 AAF0
3150 AAF0
3151 AAF0                       TITLE '6502 Opcode  Lengths'
3152 AAF0
3153 AAF0              ******************************************************
3154 AAF0              *                                                    *
3155 AAF0              *           6502 Opcode Lengths Table/Routine        *
3156 AAF0              *                  for Compatibility                 *
3157 AAF0              *                                                    *
3158 AAF0              *                         by                         *
3159 AAF0              *                    Fern Bachman                    *
3160 AAF0              *                    Joe  Bo                         *
3161 AAF0              *                                                    *
3162 AAF0              *       Copyright Apple Computer, Inc. 1985-1989     *
3163 AAF0              *                All Rights Reserved.                *
3164 AAF0              *                                                    *
3165 AAF0              ******************************************************
3166 AAF0
3167 AAF0
3168 AAF0              GET6502LEN EQU   *                      ;Get length of 6502 opcodes
3169 AAF0 48                    PHA                            ;Save opcode
3170 AAF1 29 03                 AND   #$03                     ;Create shift counter
3171 AAF3 A8                    TAY                            ;Save shift counter in 'Y'
3172 AAF4 68                    PLA                            ;Recall opcode
3173 AAF5 4A                    LSR   A                        ;Divide by 4
3174 AAF6 4A                    LSR   A                        ;
3175 AAF7 AA                    TAX                            ;Index into LEN6502OP table created now
3176 AAF8 BF 08 AB FF           LDA   >LEN6502OP,X             ;Pick up 4 opcode lengths
3177 AAFC              @1       EQU   *
3178 AAFC 88                    DEY                            ;Decrement shift counter
3179 AAFD 30 04                 BMI   @2                       ;Done when shift counter is '-'
3180 AAFF 4A                    LSR   A                        ;Do a shift
3181 AB00 4A                    LSR   A                        ;Shift 2 bits at a time
3182 AB01 80 F9                 BRA   @1                       ;Always loop
3183 AB03
3184 AB03              @2       EQU   *
3185 AB03 29 03                 AND   #$03                     ;Only low 2 bits are valid
3186 AB05 85 2F                 STA   LENGTH                   ;Save for application
3187 AB07 60                    RTS                            ;
3188 AB08
3189 AB08
3190 AB08              ***************************************************
3191 AB08              *                                                 *
3192 AB08              *         6502 Opcodes Instruction Lengths-1      *
3193 AB08              *                                                 *
3194 AB08              ***************************************************
3195 AB08
3196 AB08                                                      ; SEG $FF
3197 AB08              LEN6502OP EQU   *                       ;Length-1 of 6502 opcodes table
3198 AB08                                                      ; SEG $00
3199 AB08
3200 AB08              * illegal {03} - illegal {02} - ORA (d,X) {01} - BRK i {00}
3201 AB08 04                    DC B:%00000100
3202 AB09
3203 AB09              * illegal {07} - ASL d {06} - ORA d {05} - illegal {04}
3204 AB09 14                    DC B:%00010100
3205 AB0A
3206 AB0A              * illegal {0B} - ASL  {0A} - ORA # {09} - PHP s {08}
3207 AB0A 04                    DC B:%00000100
3208 AB0B
3209 AB0B              * illegal {0F} - ASL a {0E} - ORA a {0D} - illegal {0C}
3210 AB0B 28                    DC B:%00101000
3211 AB0C
3212 AB0C              * illegal {13} - illegal {12} - ORA (d),Y {11} - BPL r {10}
3213 AB0C 05                    DC B:%00000101
3214 AB0D
3215 AB0D              * illegal {17} - ASL d,X {16} - ORA d,X {15} - illegal {14}
3216 AB0D 14                    DC B:%00010100
3217 AB0E
3218 AB0E              * illegal {1B} - illegal {1A} - ORA a,Y {19} - CLC i {18}
3219 AB0E 08                    DC B:%00001000
3220 AB0F
3221 AB0F              * illegal {1F} - ASL a,X {1E} - ORA a,X {1D} - illegal {1C}
3222 AB0F 28                    DC B:%00101000
3223 AB10
3224 AB10              * illegal {23} - illegal {22} - AND (d,X) {21} - JSR a {20}
3225 AB10 06                    DC B:%00000110
3226 AB11
3227 AB11              * illegal {27} - ROL d {26} - AND d {25} - BIT d {24}
3228 AB11 15                    DC B:%00010101
3229 AB12
3230 AB12              * illegal {2B} - ROL Acc {2A} - AND # {29} - PLP s {28}
3231 AB12 04                    DC B:%00000100
3232 AB13
3233 AB13              * illegal {2F} - ROL a {2E} - AND a {2D} - BIT a {2C}
3234 AB13 2A                    DC B:%00101010
3235 AB14
3236 AB14              * illegal {33} - illegal {32} - AND (d),Y {31} - BMI r {30}
3237 AB14 05                    DC B:%00000101
3238 AB15
3239 AB15              * illegal {37} - ROL d,X {36} - AND d,X {35} - illegal {34}
3240 AB15 14                    DC B:%00010100
3241 AB16
3242 AB16              * illegal {3B} - illegal {3A} - AND a,Y {39} - SEC i {38}
3243 AB16 08                    DC B:%00001000
3244 AB17
3245 AB17              * illegal {3F} - ROL a,X {3E} - AND a,X {3D} - illegal {3C}
3246 AB17 28                    DC B:%00101000
3247 AB18
3248 AB18              * illegal {43} - illegal {42} - EOR (d,X) {41} - RTI s {40}
3249 AB18 04                    DC B:%00000100
3250 AB19
3251 AB19              * illegal {47} - LSR d {46} - EOR d {45} - illegal {44}
3252 AB19 14                    DC B:%00010100
3253 AB1A
3254 AB1A              * illegal {4B} - LSR Acc {4A} - EOR # {49} - PHA s {48}
3255 AB1A 04                    DC B:%00000100
3256 AB1B
3257 AB1B              * illegal {07} - LSR a {4E} - EOR a {4D} - JMP a {4C}
3258 AB1B 2A                    DC B:%00101010
3259 AB1C
3260 AB1C              * illegal {53} - illegal {52} - EOR (d),Y {51} - BVC r {50}
3261 AB1C 05                    DC B:%00000101
3262 AB1D
3263 AB1D              * illegal {57} - LSR d,X {56} - EOR d,X {55} - illegal {54}
3264 AB1D 14                    DC B:%00010100
3265 AB1E
3266 AB1E              * illegal {5B} - illegal {5A} - EOR a,Y {59} - CLI i {58}
3267 AB1E 08                    DC B:%00001000
3268 AB1F
3269 AB1F              * illegal {5F} - LSR a,X {5E} - EOR a,X {5D} - illegal {5C}
3270 AB1F 28                    DC B:%00101000
3271 AB20
3272 AB20              * illegal {63} - illegal {62} - ADC (d,X) {61} - RTS s {60}
3273 AB20 04                    DC B:%00000100
3274 AB21
3275 AB21              * illegal {67} - ROR d {66} - ADC d {65} - illegal {64}
3276 AB21 14                    DC B:%00010100
3277 AB22
3278 AB22              * illegal {6B} - ROR Acc {6A} - ADC # {69} - PLA s {68}
3279 AB22 04                    DC B:%00000100
3280 AB23
3281 AB23              * illegal {6F} - ROR a {6E} - ADC a {6D} - JMP (a) {6C}
3282 AB23 2A                    DC B:%00101010
3283 AB24
3284 AB24              * illegal {73} - illegal {72} - ADC (d),Y {71} - BVS r {70}
3285 AB24 05                    DC B:%00000101
3286 AB25
3287 AB25              * illegal {77} - ROR d,X {76} - ADC d,X {75} - illegal {74}
3288 AB25 14                    DC B:%00010100
3289 AB26
3290 AB26              * illegal {7B} - illegal {7A} - ADC a,Y {79} - SEI i {78}
3291 AB26 08                    DC B:%00001000
3292 AB27
3293 AB27              * illegal {7F} - ROR a,X {7E} - ADC a,X {7D} - illegal {7C}
3294 AB27 28                    DC B:%00101000
3295 AB28
3296 AB28              * illegal {83} - illegal {82} - STA (d,X) {81} - illegal {80}
3297 AB28 04                    DC B:%00000100
3298 AB29
3299 AB29              * illegal {87} - STX d {86} - STA d {85} - STY d {84}
3300 AB29 15                    DC B:%00010101
3301 AB2A
3302 AB2A              * illegal {8B} - TXA i {8A} - illegal {89} - DEY i {88}
3303 AB2A 00                    DC B:%00000000
3304 AB2B
3305 AB2B              * illegal {8F} - STX a {8E} - STA a {8D} - STY a {8C}
3306 AB2B 2A                    DC B:%00101010
3307 AB2C
3308 AB2C              * illegal {93} - illegal {91} - STA (d),Y {91} - BCC r {90}
3309 AB2C 05                    DC B:%00000101
3310 AB2D
3311 AB2D              * illegal {97} - STX d,Y {96} - STA d,X {95} - STY d,X {94}
3312 AB2D 15                    DC B:%00010101
3313 AB2E
3314 AB2E              * illegal {9B} - TXS i {9A} - STA a,Y {99} - TYA i {98}
3315 AB2E 08                    DC B:%00001000
3316 AB2F
3317 AB2F              * illegal {9F} - illegal {9E} - STA a,X {9D} - illegal {9C}
3318 AB2F 08                    DC B:%00001000
3319 AB30
3320 AB30              * illegal {A3} - LDX # {A2} - LDA (d,X) {A1} - LDY # {A0}
3321 AB30 15                    DC B:%00010101
3322 AB31
3323 AB31              * illegal {A7} - LDX d {A6} - LDA d {A5} - LDY d {A4}
3324 AB31 15                    DC B:%00010101
3325 AB32
3326 AB32              * illegal {AB} - TAX i {AA} - LDA # {A9} - TAY i {A8}
3327 AB32 04                    DC B:%00000100
3328 AB33
3329 AB33              * illegal {AF} - LDX a {AE} - LDA a {AD} - LDY a {AC}
3330 AB33 2A                    DC B:%00101010
3331 AB34
3332 AB34              * illegal {B3} - illegal {B2} - LDA (d),Y {B1} - BCS r {B0}
3333 AB34 05                    DC B:%00000101
3334 AB35
3335 AB35              * illegal {B7} - LDX d,Y {B6} - LDA d,X {B5} - LDY d,X {B4}
3336 AB35 15                    DC B:%00010101
3337 AB36
3338 AB36              * illegal {BB} - TSX i {BA} - LDA a,Y {B9} - CLV i {B8}
3339 AB36 08                    DC B:%00001000
3340 AB37
3341 AB37              * illegal {BF} - LDX a,Y {BE} - LDA a,X {BD} - LDY a,X {BC}
3342 AB37 2A                    DC B:%00101010
3343 AB38
3344 AB38              * illegal {C3} - illegal {C2} - CMP (d,X) {C1} - CPY # {C0}
3345 AB38 05                    DC B:%00000101
3346 AB39
3347 AB39              * illegal {C7} - DEC d {C6} - CMP d {C5} - CPY d {C4}
3348 AB39 15                    DC B:%00010101
3349 AB3A
3350 AB3A              * illegal {CB} - DEX i {CA} - CMP # {C9} - INY i {C8}
3351 AB3A 04                    DC B:%00000100
3352 AB3B
3353 AB3B              * illegal {CF} - DEC a {CE} - CMP a {CD} - CPY a {CC}
3354 AB3B 2A                    DC B:%00101010
3355 AB3C
3356 AB3C              * illegal {D3} - illegal {D2} - CMP (d),Y {D1} - BNE r {D0}
3357 AB3C 05                    DC B:%00000101
3358 AB3D
3359 AB3D              * illegal {D7} - DEC d,X {D6} - CMP d,X {D5} - illegal {D4}
3360 AB3D 14                    DC B:%00010100
3361 AB3E
3362 AB3E              * illegal {DB} - illegal {DA} - CMP a,Y {D9} - CLD i {D8}
3363 AB3E 08                    DC B:%00001000
3364 AB3F
3365 AB3F              * illegal {DF} - DEC a,X {DE} - CMP a,X {DD} - illegal {DC}
3366 AB3F 28                    DC B:%00101000
3367 AB40
3368 AB40              * illegal {E3} - illegal {E2} - SBC (d,X) {E1} - CPX # {E0}
3369 AB40 05                    DC B:%00000101
3370 AB41
3371 AB41              * illegal {E7} - INC d {E6} - SBC d {E5} - CPX d {E4}
3372 AB41 15                    DC B:%00010101
3373 AB42
3374 AB42              * illegal {EB} - NOP i {EA} - SBC # {E9} - INX i {E8}
3375 AB42 04                    DC B:%00000100
3376 AB43
3377 AB43              * illegal {EF} - INC a {EE} - SBC a {ED} - CPX a {EC}
3378 AB43 2A                    DC B:%00101010
3379 AB44
3380 AB44              * illegal {F3} - illegal {F2} - SBC (d),Y {F1} - BEQ r {F0}
3381 AB44 05                    DC B:%00000101
3382 AB45
3383 AB45              * illegal {F7} - INC d,X {F6} - SBC d,X {F5} - illegal {F4}
3384 AB45 14                    DC B:%00010100
3385 AB46
3386 AB46              * illegal {FB} - illegal {FA} - SBC a,Y {F9} - SED i {F8}
3387 AB46 08                    DC B:%00001000
3388 AB47
3389 AB47              * illegal {FF} - INC a,X {FE} - SBC a,X {FD} - illegal {FC}
3390 AB47 28                    DC B:%00101000
3391 AB48
3392 AB48
